package de.fraunhofer.sit.c2x.pki.ca.module.threadpool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;

import com.google.inject.Inject;
import com.google.inject.name.Named;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.ThreadPool;
import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class ThreadPoolImpl implements ThreadPool {

	@InjectLogger
	private Logger logger;

	@Inject
	@Named(value = "caName")
	private String caName;

	private final ThreadPoolExecutor pool;

	private int corePoolSize;

	private int maximumPoolSize;

	private int capacity;

	@Inject
	public ThreadPoolImpl() {
		corePoolSize = 2*Runtime.getRuntime().availableProcessors();
		maximumPoolSize = corePoolSize;
		long keepAliveTime = 0;
		TimeUnit unit = TimeUnit.MINUTES;
		capacity = 1000;
		BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<>(capacity);
		pool = new ThreadPoolExecutor(maximumPoolSize, maximumPoolSize,
				keepAliveTime, unit, workQueue, new ThreadFactory() {

					private int threadNum = 0;

					@Override
					public Thread newThread(Runnable r) {
						String threadName = String.format(caName
								+ " worker %02x", ++threadNum);
						logger.info("New worker thread created: \""
								+ threadName + "\"");
						Thread t = new NDCLoggerThread(r, threadName);
						t.setDaemon(true);
						return t;
					}
				}, new RejectedExecutionHandler() {

					@Override
					public void rejectedExecution(Runnable r,
							ThreadPoolExecutor executor) {
						logger.error("rejected");
					}
				});
	}

	@Override
	public ThreadPoolExecutor get() {
		logger.info("Threadpool: corePoolSize=" + pool.getCorePoolSize()
				+ " maxPoolSize=" + pool.getMaximumPoolSize()
				+ " queueCapacity=" + capacity);
		return pool;
	}

}
