package de.fraunhofer.sit.c2x.pki.ca;

import java.util.List;

import org.apache.log4j.Logger;

import com.google.inject.Inject;
import com.google.inject.name.Named;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;

public class CertificateAuthorityImpl extends CertificateAuthority implements
		Service {

	@InjectLogger
	private Logger logger;

	private final List<Service> services;

	private final String name;

	private boolean started = false;

	@Inject
	public CertificateAuthorityImpl(@Named(value = "caName") String name,
			List<Service> services) {
		this.name = name;
		this.services = services;
	}

	@Override
	public void startService() {
		for (Service service : services) {
			logger.info("START SERVICE: " + service.getName());
			service.startService();
		}
		started = true;
		logger.info("Service " + getName() + " started");

	}

	@Override
	public void stopService() {
		for (Service service : services) {
			if (service.isStarted()) {
				service.stopService();
				logger.info("STOP SERVICE: " + service.getName());
			}
		}
		started = false;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public boolean isStarted() {
		return started;
	}
}
