package de.fraunhofer.sit.c2x.pki.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;

import de.fraunhofer.sit.c2x.CertChain;
import de.fraunhofer.sit.c2x.RegionRestriction;
import de.fraunhofer.sit.c2x.pki.CertChainGenerator;
import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.ca.crypto.CryptoUtils;
import de.fraunhofer.sit.c2x.pki.ca.crypto.KeyGenerator;
import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Certificate;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.CircularRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.IdentifiedRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PolygonalRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RectangularRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RegionTypeImpl.RegionType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SubjectTypeImpl.SubjectType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.TwoDLocation;

public class CertChainGeneratorTester {

	public static void main(String[] args) throws HandlerException {

		// generate signing key pair
		AsymmetricCipherKeyPair signingKeyPair = KeyGenerator.getInstance().generateECKeyPair("P-256");

		ArrayList<byte[]> signingKeysX = new ArrayList<>();
		byte[] signingKeyX = CryptoUtils.getPublicKeyX(signingKeyPair.getPublic(), 32);
		signingKeysX.add(signingKeyX);

		ArrayList<byte[]> signingKeysY = new ArrayList<>();
		byte[] signingKeyY = CryptoUtils.getPublicKeyY(signingKeyPair.getPublic(), 32);
		signingKeysY.add(signingKeyY);

		// generate encryption key pair
		AsymmetricCipherKeyPair encryptionKeyPair = KeyGenerator.getInstance().generateECKeyPair("P-256");

		ArrayList<byte[]> encryptionKeysX = new ArrayList<>();
		byte[] encryptionKeyX = CryptoUtils.getPublicKeyX(encryptionKeyPair.getPublic(), 32);
		encryptionKeysX.add(encryptionKeyX);

		ArrayList<byte[]> encryptionKeysY = new ArrayList<>();
		byte[] encryptionKeyY = CryptoUtils.getPublicKeyY(encryptionKeyPair.getPublic(), 32);
		encryptionKeysY.add(encryptionKeyY);

		long[] aidList = new long[] { 16512l, 16513l };
		byte[][] sspList = new byte[2][];
		sspList[0] = new byte[] { 0x00 };
		sspList[1] = new byte[] { 0x00 };

		// Circular region restriction
		// ArrayList<String> certChain =
		// CertChainGenerator.getCertChainWithCircularRegionRestriction(
		// "01.01.2018", 1, aidList, sspList, 90.0000001, 180.0000001, 1);

		// Id region restriction
		// ArrayList<String> certChain =
		// CertChainGenerator.getCertChainWithIdentifiedRegionRestriction(
		// "01.01.2018", 1, aidList, sspList, "un_stats", 150, 0);

		// Rectangular region restriction
		// Double[] rectangularRegionRestrictionNorthWestPointsLatitude = new
		// Double[] { 49.8716540 };
		// Double[] rectangularRegionRestrictionNorthWestPointsLongitude = new
		// Double[] { 8.638208 };
		// Double[] rectangularRegionRestrictionSouthEastPointsLatitude = new
		// Double[] { 49.862985 };
		// Double[] rectangularRegionRestrictionSouthEastPointsLongitude = new
		// Double[] { 8.667058 };
		// ArrayList<String> certChain =
		// CertChainGenerator.getCertChainWithRectangularRegionRestriction(
		// "01.01.2018", 1, aidList, sspList,
		// rectangularRegionRestrictionNorthWestPointsLatitude,
		// rectangularRegionRestrictionNorthWestPointsLongitude,
		// rectangularRegionRestrictionSouthEastPointsLatitude,
		// rectangularRegionRestrictionSouthEastPointsLongitude);

		// Polygonal region restriction
		Double[] polygonalRegionRestrictionPointsLatitude = new Double[] { 49.871654, 49.868555, 49.204040 };
		Double[] polygonalRegionRestrictionPointsLongitude = new Double[] { 8.638208, 8.641105, 8.647560 };
		RegionRestriction rootRegionRestriction = new RegionRestriction(polygonalRegionRestrictionPointsLatitude, polygonalRegionRestrictionPointsLongitude);
		
		List<RegionRestriction> aaRegionRestrictions = new ArrayList<>();
		RegionRestriction aaRegionRestriction = new RegionRestriction(90.0000000, 180.0000000, 1);
		aaRegionRestrictions.add(aaRegionRestriction);
		
		List<RegionRestriction> atRegionRestrictions = new ArrayList<>();
		RegionRestriction atRegionRestriction = new RegionRestriction("un_stats", 150l, 0l);
		atRegionRestrictions.add(atRegionRestriction);
		
		CertChain certChain = CertChainGenerator.getCertChain("01.01.2018", 1, aidList, sspList, rootRegionRestriction, aaRegionRestrictions, atRegionRestrictions, signingKeysX, signingKeysY, encryptionKeysX,
				encryptionKeysY, 1, 1);
		
		// CertChain certChain =
		// CertChainGenerator.getCertChainWithPolygonalRegionRestriction("01.01.2018",
		// 1,
		// aidList, sspList, polygonalRegionRestrictionPointsLatitude,
		// polygonalRegionRestrictionPointsLongitude, true, signingKeysX,
		// signingKeysY, encryptionKeysX,
		// encryptionKeysY, 1, 1);

		System.out.println("------------------------------------------");

		try {
			Time32 t = WaveUtils.getElementFromBytes(Hex.decodeHex("05a4ec01".toCharArray()), Time32.class);
			System.out.println(t.getTime32().get());
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (DecoderException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		printCert(certChain.getRootCert());

		for (String aaCert : certChain.getAuthorizationAuthorityCerts()) {
			printCert(aaCert);
			for (String atCert : certChain.getAuthorizationTicketCerts(aaCert)) {
				printCert(atCert);
			}
		}
	}

	private static void printCert(String cert) {
		try {
			Certificate c = WaveUtils.getElementFromBytes(Hex.decodeHex(cert.toCharArray()),
					Certificate.class);
			System.out.println("Cert-Version:   " + c.getVersionAndType().get());
			System.out.println("Cert-Id:        " + c.getHashedId8().getCertIdHex());
			System.out.println("SubjectType:    " + c.getSubjectInfo().getSubjectType().toString());
			System.out.println("IssuerType:     " + c.getIssuerType());
			System.out.println("Issuer:         " + c.getIssuer().getCertIdHex());
			System.out.println("Start time:     " + c.getStartTime().getTime32().get() + " = 0x"
					+ Hex.encodeHexString(WaveUtils.getBytesFromWaveType(c.getStartTime())) + " = "
					+ c.getStartTime().toString());
			System.out.println("End time:       " + c.getEndTime().getTime32().get() + " = 0x"
					+ Hex.encodeHexString(WaveUtils.getBytesFromWaveType(c.getEndTime())) + " = "
					+ c.getEndTime().toString());
			System.out.println("AssuranceLevel: " + c.getSubjectAssurance().toInt() + " (0x"
					+ c.getSubjectAssurance().toHex() + ")");
			if (c.getSubjectInfo().getSubjectType() == SubjectType.AUTHORIZATION_TICKET)
				System.out.println("Permissions:    " + c.getItsAidSspListString());
			else
				System.out.println("Permissions:    " + c.getItsAidListString());
			System.out.println("RegionType:     " + c.getRegionType());

			if (c.getRegionType() == RegionType.CIRCLE) {
				CircularRegion cr = c.getCircularRegionRestriction();
				System.out.println(" ->Center Lat:  " + cr.getCenter().getLatitude());
				System.out.println(" ->Center Long: " + cr.getCenter().getLongitude());
				System.out.println(" ->Radius:      " + cr.getRadiusInt());
			} else if (c.getRegionType() == RegionType.ID) {
				IdentifiedRegion ir = c.getIdentifiedRegionRestriction();
				System.out.println(" ->Dictionary:  " + ir.getRegionDictionaryString());
				System.out.println(" ->Global ID:   " + ir.getGlobalRegionString());
				System.out.println(" ->Local ID:    " + ir.getLocalRegionId());
			} else if (c.getRegionType() == RegionType.RECTANGLE) {
				for (RectangularRegion rr : c.getRectangularRegionRestriction()) {
					System.out.println(" ->NW Lat:      " + rr.getNorthwest().getLatitude());
					System.out.println(" ->NW Long:     " + rr.getNorthwest().getLongitude());
					System.out.println(" ->SE Lat:      " + rr.getSoutheast().getLatitude());
					System.out.println(" ->SE Long:     " + rr.getSoutheast().getLongitude());
				}
			} else if (c.getRegionType() == RegionType.POLYGON) {
				PolygonalRegion pr = c.getPolygonalRegionRestriction();
				for (int i = 0; i < pr.getPolygonalRegion().length; i++) {
					TwoDLocation point = pr.getPolygonalRegion()[i];
					System.out.println(" ->P" + (i + 1) + " Lat:      " + point.getLatitude());
					System.out.println(" ->P" + (i + 1) + " Long:     " + point.getLongitude());
				}
			}

			System.out.println("------------------------------------------");
		} catch (IOException | DecoderException | HandlerException e) {
			e.printStackTrace();
		}
	}
}
