package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.validator.time;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Duration;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ValidityRestriction;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ValidityRestrictionTypeImpl.ValidityRestrictionType;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class TimeUtils {

	public static Time32 fromDuration(Time32 start, Duration duration) {
		
		return start.addSeconds(duration.getDurationInSeconds());
	}

	public static Time32[] extractTime(ValidityRestriction[] validityRestrictions) {
		Time32 start = null;
		Time32 end = null;
		for (ValidityRestriction vr : validityRestrictions) {
	
			if (vr.getType() == ValidityRestrictionType.TIME_START_AND_DURATION) {
				start = vr.getStartValidity();
				end = fromDuration(start, vr.getDuration());
				break;
			} else if (vr.getType() == ValidityRestrictionType.TIME_START_AND_END) {
				start = vr.getStartValidity();
				end = vr.getEndValidity();
				break;
			} else if (vr.getType() == ValidityRestrictionType.TIME_END) {
				start = new Time32();
				end = vr.getEndValidity();
				break;
			}
		}
		
		if (start == null || end == null) {
			throw new IllegalArgumentException();
		}
		
		return new Time32[]{start, end};
	}

}
