package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils;

import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.ByteUtils;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 * @param <EnumType>
 */
public abstract class EnumMapping<EnumType> {

	private BiDirectionalMap<Integer, EnumType> mapping = new BiDirectionalMap<>();

	protected int writtenBytelength = 1;

	protected EnumMapping() {
		initMapping(mapping);
	}

	protected abstract void initMapping(BiDirectionalMap<Integer, EnumType> map);

	public EnumType getEnumType(byte code) {

		int codeInt = code & 0xFF;
		return getEnumType(codeInt);
	}

	public EnumType getEnumType(int code) {
		EnumType ret = mapping.getValueByKey(code);
		if (ret == null) {
			throw new IllegalArgumentException("Enum Type " + code
					+ " not found");
		}
		return ret;
	}

	public int getCode(EnumType enumType) {

		Integer ret = mapping.getKeyByValue(enumType);
		if (ret == null)
			throw new IllegalArgumentException("code not found "+enumType+" "+ getClass().getGenericSuperclass());
		return ret;

	}

	public int writeData(DataOutputStream out, EnumType enumType)
			throws IOException {

		return writeData(out, enumType, writtenBytelength);
	}

	public int writeData(DataOutputStream out, EnumType enumType, int length)
			throws IOException {
		Integer code = getCode(enumType);
		if (code == null) {
			throw new IllegalArgumentException("Unknown code");
		}
		if (length == 1) {
			out.write((byte) code.intValue());
		} else if (length == 2) {
			out.write(ByteUtils.convertIntTo2ByteArray(code));
		} else {
			throw new IllegalArgumentException("Length must be 1 or 2");
		}
		return length;
	}
}
