package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.WaveType;
import de.fraunhofer.sit.c2x.pki.ca.utils.ByteUtils;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public abstract class WaveElement implements WaveType {

	@Override
	public String toString() {
		try {

			String ret = getClass().getSimpleName() + " [";
			for (Field f : getClass().getDeclaredFields()) {
				f.setAccessible(true);
				if (f.getType().getSimpleName().equals("byte[]")) {
					ret += f.getName() + "="
							+ ByteUtils.getHex((byte[]) f.get(this)) + ", ";
				} else {
					ret += f.getName() + "=" + f.get(this) + ", ";
				}
			}
			ret = ret.substring(0, ret.length() - 2) + "]";
			return ret;
		} catch (IllegalArgumentException | IllegalAccessException e) {
			return "";
		}

	}

	// TODO: WIP
	// public int hashCode() {
	// final int prime = 31;
	// int result = 1;
	// for (Field f : WaveElement.class.getDeclaredFields()) {
	// try {
	// f.setAccessible(true);
	// Class<?> type = f.getType();
	// if (type.isArray()) {
	// result = prime * result
	// + Arrays.hashCode((Object[]) f.get(this));
	// } else if (type.isPrimitive()) {
	// if (type.getName().equalsIgnoreCase("boolean")) {
	// result = prime * result
	// + (f.getBoolean(this) ? 1231 : 1237);
	// } else if (type.getName().equalsIgnoreCase("long")) {
	// long l = f.getLong(this);
	// result = prime * result + (int) (l ^ (l >>> 32));
	// } else if (type.getName().equalsIgnoreCase("int")) {
	// result = prime * result + f.getInt(this);
	// } else if (type.getName().equalsIgnoreCase("char")) {
	// } else {
	//
	// }
	// }
	// } catch (IllegalArgumentException e) {
	// e.printStackTrace();
	// } catch (IllegalAccessException e) {
	// e.printStackTrace();
	// }
	// System.out.println(f.getType().isArray());
	// }
	// // result = prime * result + (myBool ? 1231 : 1237);
	// // result = prime * result + Arrays.hashCode(myByte);
	// // result = prime * result + myChar;
	// // result = prime * result + myInt;
	// // result = prime * result + (int) (myLong ^ (myLong >>> 32));
	// // result = prime * result
	// // + ((myString == null) ? 0 : myString.hashCode());
	// return result;
	// }

	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}

		for (Field f : getClass().getDeclaredFields()) {
			f.setAccessible(true);
			try {
				Object ob = f.get(this);

				Field f2 = obj.getClass().getDeclaredField(f.getName());
				f2.setAccessible(true);
				Object ob2 = f2.get(obj);
				if (f.getType().isArray()) {
					if (!f2.getType().isArray()) {
						return false;
					} else {

						Object array1 = f.get(this);
						Object array2 = f2.get(obj);
						if (array1 == null) {
							if (array2 != null) {
								return false;
							}
						} else {

							int length1 = Array.getLength(array1);
							if (length1 != Array.getLength(array2)) {
								return false;
							} else {
								for (int i = 0; i < length1; i++) {
									if (!Array.get(array1, i).equals(
											Array.get(array2, i))) {
										return false;
									}
								}
								return true;
							}
						}

					}
				} else {
					// if (f.getType().isPrimitive()) {
					// if (!f2.getType().isPrimitive()) {
					// return false;
					// } else if (!ob.equals(ob2)) {
					//
					// return false;
					// }
					// } else {

					if (ob == null) {
						if (ob2 != null) {
							return false;
						}
					} else if (!ob.equals(ob2)) {
						return false;
					}
					// }
				}
			} catch (IllegalArgumentException | IllegalAccessException
					| NoSuchFieldException | SecurityException e) {
				e.printStackTrace();
				return false;
			}
		}

		return true;
	}

}
