package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class SInt64 extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private long data;

	// ---- fields ----

	// ---- constructors ----

	public SInt64() {
	}

	public SInt64(DataInputStream in) throws IOException {
		this.data = in.readLong();
	}
	
	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public long get() {
		return data;
	}

	// ---- setter ----

	public void set(long data) {
		this.data = data;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		out.writeLong(data);
		return 8;
	}
}