package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import org.apache.commons.codec.binary.Hex;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ItsAidPrioritySsp extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private IntX itsAid;

	@Internal(order = 1)
	private UInt8 maxPriority;

	@Internal(order = 2)
	private Opaque serviceSpecificPermissions;

	// ---- constructors ----

	public ItsAidPrioritySsp() {
	}
	
	public ItsAidPrioritySsp(long itsAid, int maxPriority, byte[] serviceSpecificPermissions) {
		this.itsAid = new IntX(itsAid);
		this.maxPriority = new UInt8(maxPriority);
		this.serviceSpecificPermissions = new Opaque(serviceSpecificPermissions);
	}

	public ItsAidPrioritySsp(DataInputStream in) throws IOException {
		itsAid = new IntX(in);
		maxPriority = new UInt8(in);
		serviceSpecificPermissions = new Opaque(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public IntX getItsAid() {
		return this.itsAid;
	}

	public UInt8 getMaxPriority() {
		return this.maxPriority;
	}

	public Opaque getServiceSpecificPermissions() {
		return this.serviceSpecificPermissions;
	}

	// ---- setter ----

	public void setItsAid(IntX itsAid) {
		this.itsAid = itsAid;
	}

	public void setMaxPriority(UInt8 maxPriority) {
		this.maxPriority = maxPriority;
	}

	public void setServiceSpecificPermissions(Opaque serviceSpecificPermissions) {
		this.serviceSpecificPermissions = serviceSpecificPermissions;
	}

	@Override
	public String toString() {
		return "ItsAidPrioritySsp [itsAid=" + itsAid.getValue() + ", maxPriority=" + maxPriority.get()
				+ ", serviceSpecificPermissions=" + Hex.encodeHexString(serviceSpecificPermissions.get()) + "]";
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (itsAid == null || maxPriority == null
				|| serviceSpecificPermissions == null)
			throw new IllegalArgumentException();
		int written = itsAid.writeData(out);
		written += maxPriority.writeData(out);
		written += serviceSpecificPermissions.writeData(out);
		return written;
	}
}