package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * @author Sebastian Mauthofer (sebastian.mauthofer@sit.fraunhofer.de)
 */
public class IntX extends WaveElement {

	protected long value;

	public IntX() {
	}

	public IntX(DataInputStream in) throws IOException {
		value = WaveUtils.readIntX(in);
	}

	public IntX(long value) {
		this.value = value;
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public Long getValue() {
		return this.value;
	}

	public void setValue(long value) {
		this.value = value;
	}

	@Override
	public String toString() {
		return "IntX [value=" + value + "]";
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (value < 0)
			throw new IllegalArgumentException();
		return WaveUtils.writeIntX(value, out);

	}
}