/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.subscriptions.SerialSubscription;

public final class OperatorSwitchIfEmpty<T>
implements Observable.Operator<T, T> {
    private final Observable<? extends T> alternate;

    public OperatorSwitchIfEmpty(Observable<? extends T> alternate) {
        this.alternate = alternate;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        SerialSubscription ssub = new SerialSubscription();
        SwitchIfEmptySubscriber parent = new SwitchIfEmptySubscriber(child, ssub);
        ssub.set(parent);
        child.add(ssub);
        return parent;
    }

    private class SwitchIfEmptySubscriber
    extends Subscriber<T> {
        boolean empty = true;
        final AtomicLong consumerCapacity = new AtomicLong(0L);
        private final Subscriber<? super T> child;
        final SerialSubscription ssub;

        public SwitchIfEmptySubscriber(Subscriber<? super T> child, SerialSubscription ssub) {
            this.child = child;
            this.ssub = ssub;
        }

        @Override
        public void setProducer(final Producer producer) {
            super.setProducer(new Producer(){

                @Override
                public void request(long n) {
                    if (SwitchIfEmptySubscriber.this.empty) {
                        SwitchIfEmptySubscriber.this.consumerCapacity.set(n);
                    }
                    producer.request(n);
                }
            });
        }

        @Override
        public void onCompleted() {
            if (!this.empty) {
                this.child.onCompleted();
            } else if (!this.child.isUnsubscribed()) {
                this.subscribeToAlternate();
            }
        }

        private void subscribeToAlternate() {
            this.ssub.set(OperatorSwitchIfEmpty.this.alternate.unsafeSubscribe(new Subscriber<T>(){

                @Override
                public void setProducer(final Producer producer) {
                    SwitchIfEmptySubscriber.this.child.setProducer(new Producer(){

                        @Override
                        public void request(long n) {
                            producer.request(n);
                        }
                    });
                }

                @Override
                public void onStart() {
                    long capacity = SwitchIfEmptySubscriber.this.consumerCapacity.get();
                    if (capacity > 0L) {
                        this.request(capacity);
                    }
                }

                @Override
                public void onCompleted() {
                    SwitchIfEmptySubscriber.this.child.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    SwitchIfEmptySubscriber.this.child.onError(e);
                }

                @Override
                public void onNext(T t) {
                    SwitchIfEmptySubscriber.this.child.onNext(t);
                }
            }));
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.empty = false;
            this.child.onNext(t);
        }
    }
}

