/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xpath.regex.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EXIRegularExpression
extends RegularExpression {
    public static final int MAX_NUMBER_OF_CHARACTERS = 255;
    private static final long serialVersionUID = 1L;
    protected Set<Integer> set = new HashSet<Integer>();
    protected boolean isRestrictedSet = true;
    static String Letters = "L[ultmo]?";
    static String Marks = "M[nce]?";
    static String Numbers = "N[dlo]?";
    static String Punctuation = "P[cdseifo]?";
    static String Separators = "Z[slp]?";
    static String Symbols = "S[mcko]?";
    static String Others = "C[cfon]?";
    static String IsCategory = "(" + Letters + ")|(" + Marks + ")|(" + Numbers + ")|(" + Punctuation + ")|(" + Separators + ")|(" + Symbols + ")|(" + Others + ")";
    static String IsBlock = "Is[a-zA-Z0-9-]+";
    static String charProp = "(" + IsCategory + ")|(" + IsBlock + ")";
    static String catEsc = "\\\\p\\{(" + charProp + ")\\}";
    static String complEsc = "\\\\P\\{(" + charProp + ")\\}";
    static String MultiCharEsc2 = "\\\\[SiIcCdDwW]";

    public EXIRegularExpression(String regex) {
        super(regex, "X");
        String sanitizedString = regex.replaceAll("[^\u0000-\uffff]", "");
        if (sanitizedString.length() != regex.length()) {
            this.isRestrictedSet = false;
            return;
        }
        Pattern pCatEsc = Pattern.compile(catEsc);
        Matcher mCatEsc = pCatEsc.matcher(regex);
        if (mCatEsc.find()) {
            this.isRestrictedSet = false;
            return;
        }
        Pattern pComplexEsc = Pattern.compile(complEsc);
        Matcher mComplexEsc = pComplexEsc.matcher(regex);
        if (mComplexEsc.find()) {
            this.isRestrictedSet = false;
            return;
        }
        Pattern pMultiCharEsc2 = Pattern.compile(MultiCharEsc2);
        Matcher mMultiCharEsc2 = pMultiCharEsc2.matcher(regex);
        while (mMultiCharEsc2.find()) {
            int start = mMultiCharEsc2.start();
            if (start > 0 && regex.charAt(start) == '\\' && regex.charAt(start - 1) == '\\') continue;
            this.isRestrictedSet = false;
            return;
        }
        this.handleToken(this.tokentree);
    }

    protected void addChar(int cp) {
        this.set.add(cp);
    }

    public boolean isEntireSetOfXMLCharacters() {
        return this.set.isEmpty() || !this.isRestrictedSet || this.set.size() > 255;
    }

    public Set<Integer> getCodePoints() {
        return this.set;
    }

    protected void handleToken(Token t) {
        if (!this.isRestrictedSet || this.set.size() > 255) {
            return;
        }
        switch (t.type) {
            case 11: {
                this.isRestrictedSet = false;
                break;
            }
            case 0: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                Token.CharToken cht = (Token.CharToken)t;
                this.addChar(cht.getChar());
                break;
            }
            case 10: {
                Token.StringToken st = (Token.StringToken)t;
                String str = st.getString();
                int L = str.codePointCount(0, str.length());
                int i = 0;
                while (i < L) {
                    this.addChar(str.codePointAt(i));
                    ++i;
                }
                break;
            }
            case 4: {
                RangeToken rt = (RangeToken)t;
                int[] ranges = rt.ranges;
                int k = 0;
                while (k < ranges.length) {
                    if (ranges[k + 1] - ranges[k] > 255) {
                        this.isRestrictedSet = false;
                        return;
                    }
                    int codePoint = ranges[k];
                    while (codePoint <= ranges[k + 1]) {
                        this.addChar(codePoint);
                        ++codePoint;
                    }
                    k += 2;
                }
                break;
            }
            case 1: 
            case 2: {
                if (t instanceof Token.UnionToken) {
                    Token.UnionToken ut = (Token.UnionToken)t;
                    Vector children = ut.children;
                    int i = 0;
                    while (i < children.size()) {
                        Token subToken = (Token)children.get(i);
                        this.handleToken(subToken);
                        ++i;
                    }
                    break;
                }
                assert (t instanceof Token.ConcatToken);
                Token.ConcatToken cot = (Token.ConcatToken)t;
                this.handleToken(cot.child);
                break;
            }
            case 3: {
                Token.ClosureToken clt = (Token.ClosureToken)t;
                this.handleToken(clt.child);
                break;
            }
            case 6: {
                Token.ParenToken pt = (Token.ParenToken)t;
                this.handleToken(pt.child);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new RuntimeException("[EXI] RegExprToken " + t + " not handled!");
            }
        }
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof EXIRegularExpression)) {
                return false;
            }
            EXIRegularExpression r = (EXIRegularExpression)((Object)obj);
            return this.set.equals(r.set);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.set.hashCode();
    }
}

