/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.values;

import com.siemens.ct.exi.Constants;
import com.siemens.ct.exi.values.AbstractValue;
import com.siemens.ct.exi.values.ValueType;

public class BooleanValue
extends AbstractValue {
    private static final long serialVersionUID = -5198071608091328620L;
    private static final BooleanValue BOOLEAN_VALUE_FALSE = new BooleanValue(false);
    private static final BooleanValue BOOLEAN_VALUE_TRUE = new BooleanValue(true);
    protected final boolean bool;
    protected final char[] characters;
    protected final String sValue;

    public BooleanValue(boolean bool) {
        super(ValueType.BOOLEAN);
        this.bool = bool;
        if (bool) {
            this.characters = Constants.DECODED_BOOLEAN_TRUE_ARRAY;
            this.sValue = "true";
        } else {
            this.characters = Constants.DECODED_BOOLEAN_FALSE_ARRAY;
            this.sValue = "false";
        }
    }

    public BooleanValue(int boolID) {
        super(ValueType.BOOLEAN);
        switch (boolID) {
            case 0: {
                this.characters = Constants.XSD_BOOLEAN_FALSE_ARRAY;
                this.sValue = "false";
                this.bool = false;
                break;
            }
            case 1: {
                this.characters = Constants.XSD_BOOLEAN_0_ARRAY;
                this.sValue = "0";
                this.bool = false;
                break;
            }
            case 2: {
                this.characters = Constants.XSD_BOOLEAN_TRUE_ARRAY;
                this.sValue = "true";
                this.bool = true;
                break;
            }
            case 3: {
                this.characters = Constants.XSD_BOOLEAN_1_ARRAY;
                this.sValue = "1";
                this.bool = true;
                break;
            }
            default: {
                throw new RuntimeException("Error while decoding boolean pattern facet");
            }
        }
    }

    public static BooleanValue parse(String value) {
        if ((value = value.trim()).equals("0") || value.equals("false")) {
            return BOOLEAN_VALUE_FALSE;
        }
        if (value.equals("1") || value.equals("true")) {
            return BOOLEAN_VALUE_TRUE;
        }
        return null;
    }

    public boolean toBoolean() {
        return this.bool;
    }

    public int getCharactersLength() {
        return this.characters.length;
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        System.arraycopy(this.characters, 0, cbuffer, offset, this.characters.length);
    }

    public String toString() {
        return this.sValue;
    }

    public String toString(char[] cbuffer, int offset) {
        return this.sValue;
    }

    private final boolean _equals(BooleanValue o) {
        return this.bool == o.bool;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof BooleanValue) {
            return this._equals((BooleanValue)o);
        }
        BooleanValue bv = BooleanValue.parse(o.toString());
        return bv == null ? false : this._equals(bv);
    }

    public int hashCode() {
        return this.bool ? 1 : 0;
    }
}

