/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.grammar;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.grammar.AbstractGrammar;
import com.siemens.ct.exi.grammars.grammar.BuiltInGrammar;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.grammars.production.SchemaLessProduction;
import com.siemens.ct.exi.util.MethodsBag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractBuiltInGrammar
extends AbstractGrammar
implements BuiltInGrammar {
    private static final long serialVersionUID = -4412097592336436189L;
    protected List<Production> containers = new ArrayList<Production>();
    protected int eventCount = 0;

    public final boolean isSchemaInformed() {
        return false;
    }

    public boolean hasSecondOrThirdLevel(FidelityOptions fidelityOptions) {
        return true;
    }

    public Grammar getTypeEmpty() {
        return this;
    }

    public int get1stLevelEventCodeLength(FidelityOptions fidelityOptions) {
        return this.hasSecondOrThirdLevel(fidelityOptions) ? MethodsBag.getCodingLength(this.eventCount + 1) : MethodsBag.getCodingLength(this.eventCount);
    }

    public int getNumberOfEvents() {
        return this.containers.size();
    }

    public final void addProduction(Event event, Grammar grammar) {
        this.containers.add(new SchemaLessProduction(this, grammar, event, this.getNumberOfEvents()));
        this.eventCount = this.containers.size();
    }

    protected boolean contains(Event event) {
        Iterator<Production> iter = this.containers.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getEvent().equals(event)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfDeclaredAttributes() {
        throw new RuntimeException("Schema-related attribute dealing in schema-less case");
    }

    public int getLeastAttributeEventCode() {
        throw new RuntimeException("Schema-related attribute dealing in schema-less case");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.getLabel()) + "//" + "\t");
        sb.append("[");
        int ec = 0;
        while (ec < this.getNumberOfEvents()) {
            sb.append("," + this.getProduction(ec).getEvent());
            ++ec;
        }
        sb.append("]");
        return sb.toString();
    }

    public Production getProduction(EventType eventType) {
        for (Production ei : this.containers) {
            if (!ei.getEvent().isEventType(eventType)) continue;
            return ei;
        }
        return null;
    }

    public Production getStartElementProduction(String namespaceURI, String localName) {
        for (Production ei : this.containers) {
            if (!ei.getEvent().isEventType(EventType.START_ELEMENT) || !AbstractBuiltInGrammar.checkQualifiedName(((StartElement)ei.getEvent()).getQName(), namespaceURI, localName)) continue;
            return ei;
        }
        return null;
    }

    public Production getStartElementNSProduction(String namespaceURI) {
        return null;
    }

    public Production getAttributeProduction(String namespaceURI, String localName) {
        for (Production ei : this.containers) {
            if (!ei.getEvent().isEventType(EventType.ATTRIBUTE) || !AbstractBuiltInGrammar.checkQualifiedName(((Attribute)ei.getEvent()).getQName(), namespaceURI, localName)) continue;
            return ei;
        }
        return null;
    }

    public Production getAttributeNSProduction(String namespaceURI) {
        return null;
    }

    public Production getProduction(int eventCode) {
        assert (eventCode >= 0 && eventCode < this.containers.size());
        return this.containers.get(this.getNumberOfEvents() - 1 - eventCode);
    }
}

