/*
 * Decompiled with CFR 0.152.
 */
package com.commsignia.v2x.client.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ModelUtilities {
    private static final Pattern a = Pattern.compile("^([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2})$");
    private static final Pattern b = Pattern.compile("^([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2}):([0-9A-Za-z]{2})$");

    private ModelUtilities() {
    }

    public static byte[] parseGNAddress(String address) {
        byte[] byArray = new byte[8];
        Matcher matcher = b.matcher(address);
        if (matcher.find()) {
            for (int i2 = 1; i2 <= 8; ++i2) {
                String string = matcher.group(i2);
                byArray[i2 - 1] = (byte)Integer.parseInt(string, 16);
            }
        } else {
            String string;
            throw new IllegalArgumentException("Invalid GN address: " + string);
        }
        return byArray;
    }

    public static byte[] parseMACAddress(String address) {
        byte[] byArray = new byte[6];
        Matcher matcher = a.matcher(address);
        if (matcher.find()) {
            for (int i2 = 1; i2 <= 6; ++i2) {
                String string = matcher.group(i2);
                byArray[i2 - 1] = (byte)Integer.parseInt(string, 16);
            }
        } else {
            String string;
            throw new IllegalArgumentException("Invalid MAC address: " + string);
        }
        return byArray;
    }
}

