/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.voip;

import java.util.ArrayList;
import java.util.List;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.voip.RtcpSSRC;

@Header(length=4, name="RTCP-SDES", suite=ProtocolSuite.TCP_IP)
public class RtcpSDES
extends RtcpSSRC {
    public static final int ID = 51;

    @Field(offset=3, length=5, display="source count")
    public int sc() {
        return (super.getByte(0) & 0x1F) >> 0;
    }

    @Field(offset=100, length=32)
    public RtcpSDESChunk[] chunks() {
        return this.chunks(new RtcpSDESChunk[this.sc()]);
    }

    public RtcpSDESChunk[] chunks(RtcpSDESChunk[] rtcpSDESChunkArray) {
        int n = this.sc();
        int n2 = 4;
        for (int i = 0; i < n && i < rtcpSDESChunkArray.length; ++i) {
            if (rtcpSDESChunkArray[i] == null) {
                rtcpSDESChunkArray[i] = new RtcpSDESChunk();
            }
            int n3 = this.readChunk(this, n2, rtcpSDESChunkArray[i]);
            n2 += n3;
        }
        return rtcpSDESChunkArray;
    }

    private int readChunk(JBuffer jBuffer, int n, RtcpSDESChunk rtcpSDESChunk) {
        int n2 = 4;
        rtcpSDESChunk.list.clear();
        int n3 = n + 4;
        for (int i = 0; i < 255; ++i) {
            int n4 = RtcpSDESItem.readType(jBuffer, n3);
            if (n4 == 0) {
                n2 = RtcpSDES.pad4(n2);
                n3 = RtcpSDES.pad4(n3);
                break;
            }
            int n5 = RtcpSDESItem.readLength(jBuffer, n3);
            if (n3 + n5 + 2 > jBuffer.size()) {
                System.out.printf("readChunk(): RTCP-SDES item: type=%d len=%d%n", n4, n5);
                continue;
            }
            rtcpSDESChunk.list.add(new RtcpSDESItem(jBuffer, n3, n5 + 2));
            n2 += n5 + 2;
            n3 += n5 + 2;
        }
        rtcpSDESChunk.setCount(rtcpSDESChunk.list.size());
        rtcpSDESChunk.peer(jBuffer, n, n2);
        return n2;
    }

    private static int pad4(int n) {
        int n2 = n + (4 - (n & 3) & 3);
        return n2;
    }

    public static class RtcpSDESChunk
    extends JBuffer {
        private final List<RtcpSDESItem> list = new ArrayList<RtcpSDESItem>(10);
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        public void setCount(int n) {
            this.count = n;
        }

        public RtcpSDESChunk() {
            super(JMemory.Type.POINTER);
        }

        public int ssrc() {
            return super.getInt(0);
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public static class RtcpSDESItem
    extends JBuffer {
        private final int offset;
        private final int length;

        public static int readType(JBuffer jBuffer, int n) {
            return jBuffer.getUByte(n + 0);
        }

        public static int readLength(JBuffer jBuffer, int n) {
            return jBuffer.getUByte(n + 1);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public RtcpSDESItem(JBuffer jBuffer, int n, int n2) {
            super(JMemory.Type.POINTER);
            this.peer(jBuffer, n, n2);
            this.offset = n;
            this.length = n2;
        }

        public int type() {
            return super.getByte(0);
        }

        public RtcpSDESType typeEnum() {
            return RtcpSDESType.valueOf(this.type());
        }

        public int length() {
            return super.getByte(1);
        }

        public String value() {
            return super.getUTF8String(2, this.length());
        }

        public String toString() {
            return this.type() == 0 ? "NOP" : String.format("%s: %s", this.typeEnum().toString(), this.value());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RtcpSDESType {
        NOP(0),
        CNAME(1),
        NAME(2),
        EMAIL(3),
        PHONE(4),
        LOC(5),
        TOOL(6),
        NOTE(7),
        PRIV(8);

        private final int type;

        private RtcpSDESType(int n2) {
            this.type = n2;
        }

        public static RtcpSDESType valueOf(int n) {
            for (RtcpSDESType rtcpSDESType : RtcpSDESType.values()) {
                if (rtcpSDESType.type != n) continue;
                return rtcpSDESType;
            }
            return null;
        }
    }
}

