/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.tcpip;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FlowKey;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.util.checksum.Checksum;

@Header(length=8)
public class Udp
extends JHeader
implements JHeaderChecksum {
    public static final int ID = 5;

    public int calculateChecksum() {
        if (this.getIndex() == -1) {
            throw new IllegalStateException("Oops index not set");
        }
        int n = this.getPreviousHeaderOffset();
        return Checksum.inChecksumShouldBe(this.checksum(), Checksum.pseudoUdp(this.packet, n, this.getOffset()));
    }

    @Field(offset=48, length=16, format="%x")
    public int checksum() {
        return this.getUShort(6);
    }

    public boolean checksum(int n) {
        super.setUShort(6, n);
        return true;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        if (this.isFragmented()) {
            return "supressed for fragments";
        }
        if (this.isPayloadTruncated()) {
            return "supressed for truncated packets";
        }
        int n = this.checksum();
        if (n == 0) {
            return "omitted";
        }
        int n2 = this.calculateChecksum();
        if (n == n2) {
            return "correct";
        }
        return "incorrect: 0x" + Integer.toHexString(n2).toUpperCase();
    }

    @Field(offset=16, length=16)
    @FlowKey(index=2, reversable=true)
    public int destination() {
        return this.getUShort(2);
    }

    public void destination(int n) {
        this.setUShort(2, n);
    }

    public boolean isChecksumValid() {
        if (this.isFragmented()) {
            return true;
        }
        if (this.getIndex() == -1) {
            throw new IllegalStateException("Oops index not set");
        }
        int n = this.getPreviousHeaderOffset();
        return Checksum.pseudoUdp(this.packet, n, this.getOffset()) == 0;
    }

    @Field(offset=32, length=16)
    public int length() {
        return this.getUShort(4);
    }

    public void length(int n) {
        this.setUShort(4, n);
    }

    public boolean recalculateChecksum() {
        return this.checksum(this.calculateChecksum());
    }

    @Field(offset=0, length=16)
    @FlowKey(index=2, reversable=true)
    public int source() {
        return this.getUShort(0);
    }

    public void source(int n) {
        this.setUShort(0, n);
    }
}

