/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JBinding;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.structure.AnnotatedHeaderLengthMethod;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinding<H extends JHeader>
implements JBinding {
    private final int targetId;
    private final int sourceId;
    private final H header;
    private AnnotatedHeaderLengthMethod[] lengthMethods;

    public AbstractBinding(Class<? extends JHeader> clazz, Class<H> clazz2) {
        this.sourceId = JRegistry.lookupId(clazz);
        this.targetId = JRegistry.lookupId(clazz2);
        try {
            this.header = (JHeader)clazz2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        try {
            this.lengthMethods = AnnotatedHeaderLengthMethod.inspectClass(clazz2);
        }
        catch (HeaderDefinitionError headerDefinitionError) {
            this.lengthMethods = null;
        }
    }

    @Override
    public int getSourceId() {
        return this.sourceId;
    }

    @Override
    public int getTargetId() {
        return this.targetId;
    }

    @Override
    public boolean isBound(JPacket jPacket, int n) {
        if (this.lengthMethods != null) {
            int n2 = this.lengthMethods[HeaderLength.Type.PREFIX.ordinal()].getHeaderLength(jPacket, n);
            jPacket.peer((JBuffer)this.header, n + n2, this.lengthMethods[HeaderLength.Type.HEADER.ordinal()].getHeaderLength(jPacket, n));
        } else {
            jPacket.peer((JBuffer)this.header, n, jPacket.remaining(n));
        }
        return this.isBound(jPacket, this.header);
    }

    public abstract boolean isBound(JPacket var1, H var2);

    @Override
    public int[] listDependencies() {
        return new int[]{this.targetId};
    }
}

