/*
 * Decompiled with CFR 0.152.
 */
package com.slytechs.util;

import java.io.IOException;
import java.util.Stack;

public class PaddedAppendable
implements Appendable {
    private final Stack<String> indent = new Stack();
    private boolean newLine;
    private final Appendable out;

    public PaddedAppendable() {
        this(System.out);
    }

    public PaddedAppendable(Appendable appendable) {
        this.out = appendable;
        this.newLine = true;
    }

    public PaddedAppendable a(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    public PaddedAppendable a(CharSequence ... charSequenceArray) throws IOException {
        if (this.newLine) {
            this.pad();
        }
        for (CharSequence charSequence : charSequenceArray) {
            this.out.append(charSequence);
        }
        return this;
    }

    public PaddedAppendable a(CharSequence charSequence, int n, int n2) throws IOException {
        this.out.append(charSequence, n, n2);
        return this;
    }

    public PaddedAppendable an(CharSequence ... charSequenceArray) throws IOException {
        this.append(charSequenceArray);
        this.nl();
        return this;
    }

    public PaddedAppendable append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    public PaddedAppendable append(CharSequence ... charSequenceArray) throws IOException {
        if (this.newLine) {
            this.pad();
        }
        for (CharSequence charSequence : charSequenceArray) {
            this.out.append(charSequence);
        }
        return this;
    }

    public PaddedAppendable append(CharSequence charSequence) throws IOException {
        if (this.newLine) {
            this.pad();
        }
        this.out.append(charSequence);
        return this;
    }

    public PaddedAppendable append(CharSequence charSequence, int n, int n2) throws IOException {
        this.out.append(charSequence, n, n2);
        return this;
    }

    public PaddedAppendable appendln(CharSequence ... charSequenceArray) throws IOException {
        this.append(charSequenceArray);
        this.nl();
        return this;
    }

    private String getPadding() {
        String string = this.indent.isEmpty() ? "" : this.indent.peek();
        return string == null ? "" : string;
    }

    public PaddedAppendable nl() throws IOException {
        this.append((CharSequence)"\n");
        this.newLine = true;
        return this;
    }

    public PaddedAppendable nl(int n) throws IOException {
        while (n-- > 0) {
            this.nl();
        }
        return this;
    }

    public PaddedAppendable pad() throws IOException {
        this.out.append(this.getPadding());
        this.newLine = false;
        return this;
    }

    public PaddedAppendable pad(String string) throws IOException {
        this.pad();
        this.append((CharSequence)string);
        return this;
    }

    public PaddedAppendable padln() throws IOException {
        this.pad();
        this.nl();
        return this;
    }

    public PaddedAppendable padln(String string) throws IOException {
        this.pad();
        this.append((CharSequence)string);
        this.nl();
        return this;
    }

    public PaddedAppendable pop() {
        this.indent.pop();
        return this;
    }

    public PaddedAppendable push() {
        return this.push("");
    }

    public PaddedAppendable push(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return this.push(stringBuilder.toString());
    }

    public PaddedAppendable push(String string) {
        this.indent.push(this.getPadding() + string);
        return this;
    }
}

