/*
 * Decompiled with CFR 0.152.
 */
package com.slytechs.library;

import com.slytechs.library.JNISymbol;
import com.slytechs.library.Library;
import com.slytechs.library.LibraryInitializer;
import com.slytechs.library.NativeLibrary;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNILibrary
extends NativeLibrary {
    private static final Map<String, JNILibrary> cache = new HashMap<String, JNILibrary>();
    private final boolean dependenciesLoaded = true;
    public final List<Error> errors;
    private final Map<String, JNISymbol> symbols = new HashMap<String, JNISymbol>();

    private static Method[] filterAllNativeMethods(Method[] methodArray) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray) {
            if ((method.getModifiers() & 0x100) == 0) continue;
            linkedList.add(method);
            method.setAccessible(true);
        }
        return linkedList.toArray(new Method[linkedList.size()]);
    }

    private static Method[] findAnnotatedMethods(Class<?> clazz, Class<LibraryInitializer> clazz2) {
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(clazz2)) continue;
            linkedList.add(method);
        }
        return linkedList.toArray(new Method[linkedList.size()]);
    }

    public static JNISymbol findSymbol(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return JNILibrary.findSymbol(clazz.getMethod(string, classArray));
        }
        catch (Exception exception) {
            return JNISymbol.NOT_FOUND_SYMBOL;
        }
    }

    public static JNISymbol findSymbol(Method method) {
        for (JNILibrary jNILibrary : cache.values()) {
            JNISymbol jNISymbol = jNILibrary.getSymbol(method);
            if (jNISymbol == null) continue;
            return jNISymbol;
        }
        return null;
    }

    public static String toStringAllLibraries() {
        StringBuilder stringBuilder = new StringBuilder();
        for (JNILibrary jNILibrary : cache.values()) {
            stringBuilder.append(jNILibrary.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    private static void invokeStaticInitializerOnClass(Class<?> clazz) {
        Method[] methodArray;
        for (Method method : methodArray = JNILibrary.findAnnotatedMethods(clazz, LibraryInitializer.class)) {
            try {
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static JNILibrary loadLibrary(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string);
        }
        LinkedList<Error> linkedList = new LinkedList<Error>();
        JNILibrary jNILibrary = JNILibrary.loadLibrary(string, linkedList) ? new JNILibrary(string) : new JNILibrary(string, linkedList);
        cache.put(string, jNILibrary);
        return jNILibrary;
    }

    public static boolean loadLibrary(String string, List<Error> list) {
        Error error = null;
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            error = unsatisfiedLinkError;
            String string2 = unsatisfiedLinkError.getMessage();
            String string3 = System.mapLibraryName(string);
            if (string2.contains("dependent libraries")) {
                error = new UnsatisfiedLinkError(string3 + " native library is found, but needs " + " dependency library(ies) installed first.");
            }
            if (string2.contains("specified procedure")) {
                error = new UnsatisfiedLinkError("Dependency version mismatch: " + string3 + " library is found, but can't find a required native function" + " call it is dependent on. Make sure all dependencies at the" + " right version levels are installed.");
            }
            if (string2.contains("java.library.path")) {
                error = new UnsatisfiedLinkError(string3 + " native library is not found. " + "Make sure its installed in /usr/lib or /usr/lib64 or " + "\\windows\\system32 or \\widows\\system64 or " + "set JVM -Djava.library.path=<dir_path_jnetpcap_library> to " + "its location.");
            }
        }
        catch (Error error2) {
            error = error2;
        }
        if (error != null) {
            list.add(error);
        }
        return error == null;
    }

    public static JNILibrary open(String string) {
        return JNILibrary.loadLibrary(string);
    }

    public static void register(Class<?> clazz) {
        Library library = clazz.getAnnotation(Library.class);
        if (library != null) {
            JNILibrary.register(library);
            JNILibrary.registerNativeMethods(library.defaultAPI(), clazz.getDeclaredMethods());
        } else {
            JNILibrary.registerNativeMethods("API 0.0.0", clazz.getDeclaredMethods());
        }
        JNILibrary.invokeStaticInitializerOnClass(clazz);
    }

    public static void register(Library library) {
        JNILibrary.register(library.natives(), library.jni(), library.preload());
    }

    public static void register(String[] stringArray, String[] stringArray2, Class<?>[] classArray) {
        for (String object : stringArray2) {
            JNILibrary.loadLibrary(object);
        }
        for (String string : stringArray) {
            NativeLibrary.loadLibrary(string);
        }
        for (Class<?> clazz : classArray) {
            try {
                Class.forName(clazz.getCanonicalName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    public static boolean registerNativeMethods(String string, Method[] methodArray) {
        for (Method method : methodArray = JNILibrary.filterAllNativeMethods(methodArray)) {
            JNILibrary.findSymbol(method);
        }
        return true;
    }

    public static boolean resolveSymbols(Class<?> clazz) {
        Method[] methodArray = JNILibrary.filterAllNativeMethods(clazz.getDeclaredMethods());
        boolean bl = true;
        for (Method method : methodArray) {
            JNISymbol jNISymbol = JNILibrary.findSymbol(method);
            if (jNISymbol == null) {
                bl = false;
                continue;
            }
            jNISymbol.register();
        }
        return bl;
    }

    public static String toStringClassSymbols(Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (JNILibrary jNILibrary : cache.values()) {
            boolean bl = false;
            stringBuilder2.setLength(0);
            stringBuilder2.append(jNILibrary.name).append("@0x").append(Long.toString(jNILibrary.address, 16));
            stringBuilder2.append('[');
            int n = stringBuilder2.length();
            for (JNISymbol jNISymbol : jNILibrary.symbols.values()) {
                boolean bl2 = false;
                for (Class<?> clazz : classArray) {
                    if (jNISymbol.clazz != clazz) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                bl = true;
                stringBuilder2.append(stringBuilder2.length() != n ? "\n " : "\n ");
                stringBuilder2.append(jNISymbol.toString());
            }
            stringBuilder2.append(stringBuilder2.length() != n ? "\n" : "");
            stringBuilder2.append("]\n");
            if (!bl) continue;
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    private JNILibrary(String string) {
        super(string);
        this.errors = Collections.emptyList();
    }

    private JNILibrary(String string, List<Error> list) {
        super(string);
        this.errors = list;
    }

    JNISymbol getSymbol(Method method) throws SecurityException {
        String string = JNISymbol.toJNIName(method);
        String string2 = JNISymbol.toJNINameAndSignature(method);
        if (this.symbols.containsKey(string)) {
            return this.symbols.get(string);
        }
        if (this.symbols.containsKey(string2)) {
            return this.symbols.get(string2);
        }
        String string3 = string;
        long l = this.dlsymbol(string3);
        if (l == 0L && (l = this.dlsymbol(string3 = string2)) == 0L) {
            return null;
        }
        JNISymbol jNISymbol = new JNISymbol(string3, l, method, this.name);
        this.symbols.put(string3, jNISymbol);
        return jNISymbol;
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("@0x").append(Long.toString(this.address, 16));
        if (!this.symbols.isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(this.symbols.size()).append(" symbols");
            int n = stringBuilder.length();
            for (JNISymbol jNISymbol : this.symbols.values()) {
                stringBuilder.append(stringBuilder.length() != n ? "\n " : "\n ");
                stringBuilder.append(jNISymbol.toString());
            }
            stringBuilder.append(stringBuilder.length() != n ? "\n" : "");
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public String toStringNotLoaded() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("@0x").append(Long.toString(this.address, 16));
        if (!this.symbols.isEmpty()) {
            stringBuilder.append('[');
            int n = stringBuilder.length();
            for (JNISymbol jNISymbol : this.symbols.values()) {
                if (jNISymbol.isLoaded()) continue;
                stringBuilder.append(stringBuilder.length() != n ? "\n " : "\n ");
                stringBuilder.append(jNISymbol.toString());
            }
            stringBuilder.append(stringBuilder.length() != n ? "\n" : "");
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

