package de.fraunhofer.sit.c2x.pki.ca.module.webservice.service;

import java.net.InetSocketAddress;
import java.util.NoSuchElementException;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;

import org.apache.log4j.Logger;
import org.eclipse.jetty.http.spi.JettyHttpsExchange;

import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;
import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.PcaSmmHandler;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.handler.interfaces.RequestErrorHandler;

@WebService(serviceName = "PcaWebService", portName = "PcaWebServicePort", targetNamespace = "http://pca.c2c.v2x_pki.escrypt.com/")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public class PcaWebService implements de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.WebService {

	@Resource
	WebServiceContext wsContext;
	private InetSocketAddress remoteAddress;

	@InjectLogger
	private Logger logger;
	
	@Inject
	private RequestErrorHandler errorHandler;

	@Inject
	private PcaSmmHandler pcaSmmHandler;

	/**
	 * 
	 * @param crlRequest
	 * @return returns byte[]
	 */
	@WebMethod
	@WebResult(name = "SMMResponse", partName = "SMMResponse")
	//@WebResult(partName = "return")
	//@Action(input = "http://pca.c2c.v2x_pki.escrypt.com/PcaWebService/processSMM", output = "http://pca.c2c.v2x_pki.escrypt.com/PcaWebService/processSMM")
	public byte[] processSMM(@WebParam(name = "SMMRequest", partName = "SMMRequest") byte[] smm) {
		try {
			if (logger.isDebugEnabled())
				logger.debug("START: handling of a PCA SMM from " + getRemoteAddress());

			byte[] responseBytes = pcaSmmHandler.handle(smm);

			if (logger.isDebugEnabled())
				logger.debug("END: handling of a PCA SMM from " + getRemoteAddress() + " (successful)");
			return responseBytes;
		} catch (HandlerException e) {
			if (logger.isDebugEnabled()) {
				logger.debug("Error handling a PCA SMM from " + getRemoteAddress()
						+ ": " + e.getMessage());
				logger.debug("END: handling of a PCA SMM from " + getRemoteAddress()
						+ " (failed)");
			}
			return errorHandler.handle(smm, e);
		}
	}

	private InetSocketAddress getRemoteAddress() {
		if (remoteAddress != null) {
			return remoteAddress;
		} else {
			Object o = wsContext.getMessageContext().get("com.sun.xml.internal.ws.http.exchange");
			if (o == null || !o.getClass().equals(JettyHttpsExchange.class)) {
				throw new NoSuchElementException("No http exchange found to get remote IP address");
			}
			JettyHttpsExchange exchange = (JettyHttpsExchange) o;
			remoteAddress = exchange.getRemoteAddress();
			return remoteAddress;
		}
	}

	@Override
	public String getPath() {
		return "/PcaSoapWebService";
	}

}
