package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.eclipse.jetty.security.authentication.SessionAuthentication;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.Servlet;

public abstract class AbstractServlet extends HttpServlet implements Servlet {

	private static final long serialVersionUID = -271935106408974775L;

	@InjectLogger
	protected Logger logger;

	protected final HtmlProvider htmlProvider;
	protected String userName;

	public AbstractServlet(HtmlProvider htmlProvider) {
		this.htmlProvider = htmlProvider;
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException,
			IOException {

		OutputStream out = resp.getOutputStream();

		HttpSession session = req.getSession();

		/* Get Content-Type. */
		String contentType = "application/xhtml+xml";

		/* Set headers. */
		resp.setHeader("Content-Type", contentType);
		// response.setHeader("Cache-Control", "max-age=604800");
		resp.setCharacterEncoding("UTF-8");

		/* Send response header with Content-Length. */
		resp.setStatus(200);

		// get user from http session
		SessionAuthentication user = (SessionAuthentication) req.getSession().getAttribute(
				SessionAuthentication.__J_AUTHENTICATED);
		if (user != null)
			userName = user.getUserIdentity().getUserPrincipal().getName().toString();
		else
			userName = "";

		out.write(htmlProvider.provide(session, getTitle(), contentHtml(req, resp)).getBytes());

		out.flush();
		out.close();
	}

	public String getUserName() {
		return userName;
	}

	protected abstract String contentHtml(HttpServletRequest req, HttpServletResponse resp);

}
