package de.fraunhofer.sit.c2x.pki.ca.core.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.exceptions.HandlerException;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 * @param <In>
 *            Class of the object you want to handle
 * @param <Out>
 *            Class of the handled result
 */
public interface HandlerWithResult<In, Out> {

	/**
	 * 
	 * @param in
	 *            the object you want to handle
	 * @return the result of the handling
	 * @throws HandlerException
	 *             if something goes wrong during the handling
	 */
	public Out handle(In in) throws HandlerException;

}
