package de.fraunhofer.sit.c2x.pki.ca.core.exceptions;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class CAException extends Exception {
	private String errorCode;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public CAException() {
		super();
	}
	
	public CAException(String msg) {
		super(msg);
	}
	
	public CAException(String msg, String errorCode) {
		super(msg);
		this.errorCode = errorCode;
	}

	public CAException(String string, Throwable cause) {
		super(string, cause);
	}

	public CAException(String string, Throwable cause, String errorCode) {
		super(string, cause);
		this.errorCode = errorCode;
	}

	public CAException(Throwable e) {
		super(e);
	}
	
	public CAException(Throwable e, String errorCode) {
		super(e);
		this.errorCode = errorCode;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

}
