#include "ConfigRsuSimulatorLayerFactory.hh"

#include "loggers.hh"

#include "ItsRSUsSimulator_TestSystem.hh"

#include "uppertester_cam_codec.hh"
#include "uppertester_geonetworking_codec.hh"

ConfigRsuSimulatorLayer::ConfigRsuSimulatorLayer(const std::string & p_type, const std::string & param) : t_layer<ItsRSUsSimulator__TestSystem::ConfigRsuSimulatorPort>(p_type), _params(), _codec(), _codec_cam() {
  loggers::get_instance().log(">>> ConfigRsuSimulatorLayer::ConfigRsuSimulatorLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  params::convert(_params, param);
}

void ConfigRsuSimulatorLayer::sendMsg(const ItsRSUsSimulator__TestSystem::CfInitialize& send_par, params& params){
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);
  
  // Encode ConfigRsuSimulator PDU
  OCTETSTRING data;
  if (_codec.encode(static_cast<const Record_Type&>(send_par), data) == -1) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Encoding failure");
    return;
  }

  send_data(data, _params);
}

void ConfigRsuSimulatorLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnResults& send_par, params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);

  TTCN_Buffer encoding_buffer;
  if (send_par.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnResults::ALT_utGnInitializeResult)) {
    encoding_buffer.put_c(0x01/*static_cast<const unsigned char>(uppertester_geonetworking_codec::c_utGnInitializeResult)*/);
    encoding_buffer.put_c((unsigned char)static_cast<const boolean>(send_par.utGnInitializeResult()));
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Unsupported UtGnResults variant");
    return;
  }

  OCTETSTRING os(encoding_buffer.get_len(), encoding_buffer.get_data());
  send_data(os, _params);
}

void ConfigRsuSimulatorLayer::sendMsg(const LibItsCam__TypesAndValues::UtCamResults& send_par, params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);

  TTCN_Buffer encoding_buffer;
  if (send_par.ischosen(LibItsCam__TypesAndValues::UtCamResults::ALT_utCamInitializeResult)) {
    encoding_buffer.put_c(0x01/*static_cast<const unsigned char>(uppertester_cam_codec::c_utCamInitializeResult)*/);
    encoding_buffer.put_c((unsigned char)static_cast<const boolean>(send_par.utCamInitializeResult()));
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Unsupported UtCamResults variant");
    return;
  }

  OCTETSTRING os(encoding_buffer.get_len(), encoding_buffer.get_data());
  send_data(os, _params);
}

void ConfigRsuSimulatorLayer::sendMsg(const LibItsDenm__TypesAndValues::UtDenmResults& send_par, params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::sendMsg: ", send_par);

  TTCN_Buffer encoding_buffer;
  if (send_par.ischosen(LibItsDenm__TypesAndValues::UtDenmResults::ALT_utDenmInitializeResult)) {
    encoding_buffer.put_c(0x01/*static_cast<const unsigned char>(uppertester_denm_codec::c_utDenmInitializeResult)*/);
    encoding_buffer.put_c((unsigned char)static_cast<const boolean>(send_par.utDenmInitializeResult()));
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::sendMsg: Unsupported UtDenmResults variant");
    return;
  }

  OCTETSTRING os(encoding_buffer.get_len(), encoding_buffer.get_data());
  send_data(os, _params);
}

void ConfigRsuSimulatorLayer::send_data(OCTETSTRING& data, params& params) {
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::send_data: ", data);
  
  send_to_all_layers(data, params);
}

void ConfigRsuSimulatorLayer::receive_data(OCTETSTRING& data, params& params)
{ // FIXME To be moved into ConfigRsuSimulatorCodec
  loggers::get_instance().log_msg(">>> ConfigRsuSimulatorLayer::receive_data: ", data);

  unsigned char id = *(static_cast<const unsigned char*>(data));
  if (id == 0x00) { // Receive an UtxxInitialise
    process_utinitialize_data(data, params);
  } else if (id == 0x31) { // Receive an UtCamChangeSpeed
    process_ut_cam_changespeed_data(data, params);
  } else if ((id >= 0x50) && (id <= 0x54)) { // Receive an UtGnTrigger
    process_ut_geonetworking_trigger(data, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::receive_data: Unsupported tag %02x", id);
  }
  
}

int ConfigRsuSimulatorLayer::process_utinitialize_data(const OCTETSTRING& data, params& params) {
  loggers::get_instance().log(">>> ConfigRsuSimulatorLayer::process_utinitialize_data");
  
  params::const_iterator it = _params.find("ut");
  if (it == _params.cend()) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_utinitialize_data: CF layer's ut parameter is missing");
    return -1;
  }

  if (_params[std::string("ut")].compare("gn") == 0) {
    OCTETSTRING hashedId(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsGeoNetworking__TypesAndValues::UtGnInitialize p(hashedId);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else if (_params[std::string("ut")].compare("cam") == 0) {
    OCTETSTRING hashedId(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsCam__TypesAndValues::UtCamInitialize p(hashedId);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else if (_params[std::string("ut")].compare("denm") == 0) {
    OCTETSTRING hashedId(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsDenm__TypesAndValues::UtDenmInitialize p(hashedId);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_utinitialize_data: Unsupported protocol");
    return -1;
  }

  return 0;
}

int ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data(const OCTETSTRING& data, params& params) {
  loggers::get_instance().log(">>> ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data");

  params::const_iterator it = _params.find("ut");
  if (it == _params.cend()) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data: CF layer's ut parameter is missing");
    return -1;
  }

  if (_params[std::string("ut")].compare("cam") == 0) {
    OCTETSTRING speed(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    LibItsCam__TypesAndValues::UtCamTrigger p;
    p.changeSpeed() = oct2int(speed);
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_ut_cam_changespeed_data: Unsupported protocol");
    return -1;
  }

  return 0;
}

int ConfigRsuSimulatorLayer::process_ut_geonetworking_trigger(const OCTETSTRING& data, params& params) {
  loggers::get_instance().log(">>> ConfigRsuSimulatorLayer::process_ut_geonetworking_trigger");

  params::const_iterator it = _params.find("ut");
  if (it == _params.cend()) {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_ut_geonetworking_trigger: CF layer's ut parameter is missing");
    return -1;
  }

  if (_params[std::string("ut")].compare("gn") == 0) {
    OCTETSTRING payload(data.lengthof() - 1,  1 + static_cast<const unsigned char*>(data));
    loggers::get_instance().log_msg("ConfigRsuSimulatorLayer::process_ut_geonetworking_trigger: payload:", payload);
    TTCN_EncDec::clear_error();
    TTCN_Buffer decoding_buffer(payload);
    LibItsGeoNetworking__TypesAndValues::GenerateGeoUnicastMessage g;
    for (int i = 0; i < g.get_count(); i++) {
      loggers::get_instance().log_to_hexa("ConfigRsuSimulatorLayer::process_ut_geonetworking_trigger: decoding_buffer=", decoding_buffer);
      g.decode(*g.fld_descr(i), decoding_buffer, TTCN_EncDec::CT_RAW);
    }
    LibItsGeoNetworking__TypesAndValues::UtGnTrigger p;
    p.geoUnicast() = g;
    // Pass it to the ports if any
    to_all_upper_ports(p, params);
  } else {
    loggers::get_instance().warning("ConfigRsuSimulatorLayer::process_ut_geonetworking_trigger: Unsupported protocol");
    return -1;
  }

  return 0;
}

ConfigRsuSimulatorLayerFactory ConfigRsuSimulatorLayerFactory::_f;
