#include "LibItsPki_EncdecDeclarations.hh"

#include "etsi_ts102941_types_enrolment_inner_request.hh"
#include "etsi_ts102941_types_enrolment_inner_response.hh"

#include "loggers.hh"

namespace LibItsPki__EncdecDeclarations {

  BITSTRING fx__enc__InnerEcRequest(const EtsiTs102941TypesEnrolment::InnerEcRequest& p_inner_request) {
    loggers::get_instance().log_msg(">>> fx_enc_InnerEcRequest: ", p_inner_request);

    etsi_ts102941_types_enrolment_inner_request codec;
    OCTETSTRING os;
    if (codec.encode(p_inner_request, os) == -1) {
      loggers::get_instance().warning("fx_enc_InnerEcRequest: -1 result code was returned");
      return int2bit(0, 1);
    }
    
    return oct2bit(os);
  }

  INTEGER fx__dec__InnerEcRequest(BITSTRING& b, EtsiTs102941TypesEnrolment::InnerEcRequest& p_inner_request) {
    loggers::get_instance().log_msg(">>> fx__dec__InnerEcRequest: ", b);

    etsi_ts102941_types_enrolment_inner_request codec;
    OCTETSTRING is = bit2oct(b);
    if (codec.decode(is, p_inner_request) == -1) {
      loggers::get_instance().warning("fx__dec__InnerEcRequest: -1 result code was returned");
      return -1;
    }
    
    loggers::get_instance().log_msg("<<< fx__dec__InnerEcRequest: ", p_inner_request);
    return 0;
  }
  
  BITSTRING fx__enc__InnerEcResponse(const EtsiTs102941TypesEnrolment::InnerEcResponse& p_inner_response) {
    loggers::get_instance().log_msg(">>> fx__enc__InnerEcResponse: ", p_inner_response);

    etsi_ts102941_types_enrolment_inner_response codec;
    OCTETSTRING os;
    if (codec.encode(p_inner_response, os) == -1) {
      loggers::get_instance().warning("fx__enc__InnerEcResponse: -1 result code was returned");
      return int2bit(0, 1);
    }

    return oct2bit(os);
  }

  INTEGER fx__dec__InnerEcResponse(BITSTRING& b, EtsiTs102941TypesEnrolment::InnerEcResponse& p_inner_response) {
    loggers::get_instance().log_msg(">>> fx__dec__InnerEcResponse: ", b);

    etsi_ts102941_types_enrolment_inner_response codec;
    OCTETSTRING is = bit2oct(b);
    if (codec.decode(is, p_inner_response) == -1) {
      loggers::get_instance().warning("fx__dec__InnerEcResponse: -1 result code was returned");
      return -1;
    }

    loggers::get_instance().log_msg("<<< fx__dec__InnerEcResponse: ", p_inner_response);
    return 0;
  }

} // End of namespace LibItsPki__EncdecDeclarations
