/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Certificate;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.CircularRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Duration;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.EccPoint;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.EcdsaSignature;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.EciesEncryptedKey;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.EncryptionParameters;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.HashedId3;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.HashedId8;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.HeaderField;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.HeadingWithConfidence;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.IdentifiedRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.IntX;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ItsAidPriority;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ItsAidPrioritySsp;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ItsAidSsp;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Opaque;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Payload;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PolygonalRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PublicKey;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RecipientInfo;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RectangularRegion;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SInt32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SInt64;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SecuredMessage;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Signature;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SignerInfo;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SpeedWithConfidence;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SubjectAttribute;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SubjectInfo;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ThreeDLocation;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time64;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.Time64WithStandardDeviation;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.TrailerField;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.TwoDLocation;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.UInt16;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.UInt32;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.UInt64;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.UInt8;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ValidityRestriction;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public interface EtsiVisitor<T> {

	public T visit(HashedId8 certId8);

	public T visit(Certificate certificate);

	public T visit(CircularRegion circularRegion);

	public T visit(EccPoint eCCPublicKey);

	public T visit(EcdsaSignature eCDSASignature);

	public T visit(EciesEncryptedKey eciesNistP256EncryptedKey);

	public T visit(de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.GeographicRegion geographicRegion);

	public T visit(Opaque opaque);

	public T visit(PolygonalRegion polygonalRegion);

	public T visit(IntX intX);

	public T visit(ItsAidPriority itsAidPriority);

	public T visit(ItsAidPrioritySsp itsAidPrioritySsp);

	public T visit(ItsAidSsp itsAidSsp);

	public T visit(PublicKey publicKey);

	public T visit(RecipientInfo recipientInfo);

	public T visit(RectangularRegion rectangularRegion);

	public T visit(Signature signature);

	public T visit(SignerInfo signerIdentifier);

	public T visit(SInt32 sInt32);

	public T visit(Time32 time32);

	public T visit(Time64 time64);

	public T visit(Time64WithStandardDeviation time64WithStandardDeviation);

	public T visit(TwoDLocation twoDLocation);

	public T visit(UInt16 uInt16);

	public T visit(UInt32 uInt32);

	public T visit(UInt64 uInt64);

	public T visit(UInt8 uInt8);

	public T visit(SpeedWithConfidence speedWithConfidenceImpl);

	public T visit(HeadingWithConfidence headingWithConfidenceImpl);

	public T visit(IdentifiedRegion identifiedRegionImpl);

	public T visit(EncryptionParameters encryptionParametersImpl);

	public T visit(HeaderField headerFieldImpl);

	public T visit(Duration durationImpl);

	public T visit(Payload payloadImpl);

	public T visit(SubjectAttribute subjectAttributeImpl);

	public T visit(ValidityRestriction validityRestrictionImpl);

	public T visit(ThreeDLocation threeDLocationImpl);

	public T visit(HashedId3 hashedId2Impl);

	public T visit(SecuredMessage securedMessageImpl);

	public T visit(TrailerField securityFieldImpl);

	public T visit(SInt64 sInt64Impl);

	public T visit(SubjectInfo subjectInfoImpl);

}
