/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.context;

import com.siemens.ct.exi.context.AbstractCoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.EvolvingUriContext;
import com.siemens.ct.exi.context.GrammarContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;

public class EncoderContextImpl
extends AbstractCoderContext
implements EncoderContext {
    StringEncoder stringEncoder;

    public EncoderContextImpl(GrammarContext grammarContext, StringEncoder stringEncoder) {
        super(grammarContext);
        this.stringEncoder = stringEncoder;
    }

    public StringEncoder getStringEncoder() {
        return this.stringEncoder;
    }

    public void clear() {
        super.clear();
        this.stringEncoder.clear();
    }

    public QNameContext encodeQName(String namespaceUri, String localName, EncoderChannel channel) throws IOException {
        EvolvingUriContext uc = this.encodeUri(namespaceUri, channel);
        return this.encodeLocalName(localName, uc, channel);
    }

    public QNameContext encodeLocalName(String localName, EvolvingUriContext uc, EncoderChannel channel) throws IOException {
        assert (uc != null);
        QNameContext qnc = uc.getQNameContext(localName);
        if (qnc == null) {
            channel.encodeUnsignedInteger(localName.length() + 1);
            channel.encodeStringOnly(localName);
            qnc = this.addQNameContext(uc, localName);
        } else {
            channel.encodeUnsignedInteger(0);
            int n = MethodsBag.getCodingLength(uc.getNumberOfQNames());
            channel.encodeNBitUnsignedInteger(qnc.getLocalNameID(), n);
        }
        return qnc;
    }

    public EvolvingUriContext encodeUri(String namespaceUri, EncoderChannel channel) throws IOException {
        int nUri = MethodsBag.getCodingLength(this.getNumberOfUris() + 1);
        EvolvingUriContext uc = this.getUriContext(namespaceUri);
        if (uc == null) {
            channel.encodeNBitUnsignedInteger(0, nUri);
            channel.encodeString(namespaceUri);
            uc = this.addUriContext(namespaceUri);
        } else {
            channel.encodeNBitUnsignedInteger(uc.getNamespaceUriID() + 1, nUri);
        }
        return uc;
    }

    public void encodeQNamePrefix(QNameContext qnContext, String prefix, EncoderChannel channel) throws IOException {
        EvolvingUriContext uriContext;
        int numberOfPrefixes;
        int namespaceUriID = qnContext.getNamespaceUriID();
        if (namespaceUriID != 0 && (numberOfPrefixes = (uriContext = this.getUriContext(namespaceUriID)).getNumberOfPrefixes()) > 1) {
            int pfxID = uriContext.getPrefixID(prefix);
            if (pfxID == -1) {
                pfxID = 0;
            }
            channel.encodeNBitUnsignedInteger(pfxID, MethodsBag.getCodingLength(numberOfPrefixes));
        }
    }

    public void encodeNamespacePrefix(EvolvingUriContext uriContext, String prefix, EncoderChannel channel) throws IOException {
        int nPfx = MethodsBag.getCodingLength(uriContext.getNumberOfPrefixes() + 1);
        int pfxID = uriContext.getPrefixID(prefix);
        if (pfxID == -1) {
            channel.encodeNBitUnsignedInteger(0, nPfx);
            channel.encodeString(prefix);
            uriContext.addPrefix(prefix);
        } else {
            channel.encodeNBitUnsignedInteger(pfxID + 1, nPfx);
        }
    }
}

