package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SubjectTypeImpl.SubjectType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class SubjectInfo extends WaveElement {

	private SubjectType subjectType;

	private Opaque subjectName;
	

	public SubjectInfo() {
	}
	
	public SubjectInfo(SubjectType subjectType, String subjectName) throws IOException {
		this.subjectType = subjectType;
		try {
			this.subjectName = new Opaque(subjectName.getBytes("UTF-8"));
			if(this.subjectName.getLength() > 32) throw new IllegalArgumentException("Subject name exceeds 32 bytes limit!");
		} catch (UnsupportedEncodingException e) {
			throw new IOException(e);
		}
	}

	public SubjectInfo(DataInputStream in) throws IOException {
		subjectType = SubjectTypeImpl.getInstance().getEnumType(in.readByte());
		subjectName = new Opaque(in);
		if(this.subjectName.getLength() > 32) throw new IllegalArgumentException("Subject name exceeds 32 bytes limit!");
	}
	
	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public SubjectType getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(SubjectType subjectType) {
		this.subjectType = subjectType;
	}

	public Opaque getSubjectName() {
		return subjectName;
	}
	
	public String getSubjectNameString() throws IOException{
		try {
			return new String(subjectName.get(),"UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new IOException(e);
		}
	}

	public void setSubjectName(Opaque subjectName) {
		if(subjectName.getLength() > 32) throw new IllegalArgumentException("Subject name exceeds 32 bytes limit!");
		this.subjectName = subjectName;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		int written = SubjectTypeImpl.getInstance().writeData(out, subjectType);
		written += WaveUtils.writeWave(out, subjectName);
		return written;
	}

}
