/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PublicKeyAlgorithmImpl.PublicKeyAlgorithm;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class PublicKeyAlgorithmImpl extends EnumMapping<PublicKeyAlgorithm> {

	public enum PublicKeyAlgorithm {

		ECDSA_NISTP256_WITH_SHA256(256), ECIES_NISTP256(256);

		private final int keyLength;

		PublicKeyAlgorithm(int keyLength) {
			this.keyLength = keyLength;
		}

		public int getKeyLength() {
			return keyLength;
		}
	}

	private static PublicKeyAlgorithmImpl instance = null;

	private PublicKeyAlgorithmImpl() {
	}

	public static PublicKeyAlgorithmImpl getInstance() {
		if (instance == null)
			instance = new PublicKeyAlgorithmImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, PublicKeyAlgorithm> map) {
		map.put(0, PublicKeyAlgorithm.ECDSA_NISTP256_WITH_SHA256);
		map.put(1, PublicKeyAlgorithm.ECIES_NISTP256);
	}

}
