/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.RectangularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.Polygon;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.Rectangle;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.PolygonUtils;


/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class CircleRectangularValidator extends AbstractCircleValidator<RectangularRegion[]> {

	private CirclePolygonValidator validator;

	/**
	 * @param circularRegion
	 */
	public CircleRectangularValidator(CircularRegion circularRegion) {
		super(circularRegion);
		validator = new CirclePolygonValidator(circularRegion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(RectangularRegion[] object) {

		Polygon[] polys = union(object);
		for (Polygon polygon : polys) {
			if (validator.validate(polygon))
				return true;
		}

		return false;
	}

	private Polygon[] union(RectangularRegion[] region) {

		Rectangle[] recs = new Rectangle[region.length];
		for (int i = 0; i < region.length; i++) {
			recs[i] = convertRectangleReion(region[i]);
		}

		return PolygonUtils.union(recs);
	}

	private Rectangle convertRectangleReion(RectangularRegion region) {

		return new Rectangle(Convert.aTwoDLocation.toVector(region.getUpperLeft()),
				Convert.aTwoDLocation.toVector(region.getLowerRight()));
	}

}
