/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.winpcap;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapBpfProgram;
import org.jnetpcap.PcapExtensionNotAvailableException;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.winpcap.WinPcapRmtAuth;
import org.jnetpcap.winpcap.WinPcapSamp;
import org.jnetpcap.winpcap.WinPcapSendQueue;
import org.jnetpcap.winpcap.WinPcapStat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinPcap
extends Pcap {
    private static final ThreadLocal<StringBuffer> buf = new ThreadLocal<StringBuffer>(){

        @Override
        protected StringBuffer initialValue() {
            return new StringBuffer();
        }
    };
    public static final int MODE_CAPT = 0;
    public static final int MODE_MONITOR = 2;
    public static final int MODE_STAT = 1;
    public static final int OPENFLAG_DATATX_UDP = 2;
    public static final int OPENFLAG_MAX_RESPONSIVENESS = 16;
    public static final int OPENFLAG_NOCAPTURE_LOCAL = 8;
    public static final int OPENFLAG_NOCAPTURE_RPCAP = 4;
    public static final int SRC_FILE = 2;
    public static final int SRC_IFLOCAL = 3;
    public static final int SRC_IFREMOTE = 4;
    public static final int TRANSMIT_SYNCH_ASAP = 0;
    public static final int TRANSMIT_SYNCH_USE_TIMESTAMP = 1;

    private static String asString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : byArray) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(Integer.toHexString(n < 0 ? n + 256 : n).toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static int createSrcStr(Appendable appendable, int n, String string, String string2, String string3, Appendable appendable2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = WinPcap.createSrcStr(stringBuffer, n, string, string2, string3, WinPcap.getBuf());
        WinPcap.toAppendable(WinPcap.getBuf(), appendable2);
        WinPcap.toAppendable(stringBuffer, appendable);
        return n2;
    }

    public static native int createSrcStr(StringBuffer var0, int var1, String var2, String var3, String var4, StringBuffer var5);

    public static int createSrcStr(StringBuilder stringBuilder, int n, String string, String string2, String string3, StringBuilder stringBuilder2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = WinPcap.createSrcStr(stringBuffer, n, string, string2, string3, WinPcap.getBuf());
        WinPcap.toStringBuilder(WinPcap.getBuf(), stringBuilder2);
        WinPcap.toStringBuilder(stringBuffer, stringBuilder);
        return n2;
    }

    public static int findAllDevsEx(String string, WinPcapRmtAuth winPcapRmtAuth, List<PcapIf> list, Appendable appendable) throws IOException {
        int n = WinPcap.findAllDevsEx(string, winPcapRmtAuth, list, WinPcap.getBuf());
        WinPcap.toAppendable(WinPcap.getBuf(), appendable);
        return n;
    }

    public static native int findAllDevsEx(String var0, WinPcapRmtAuth var1, List<PcapIf> var2, StringBuffer var3);

    public static int findAllDevsEx(String string, WinPcapRmtAuth winPcapRmtAuth, List<PcapIf> list, StringBuilder stringBuilder) {
        int n = WinPcap.findAllDevsEx(string, winPcapRmtAuth, list, WinPcap.getBuf());
        WinPcap.toStringBuilder(WinPcap.getBuf(), stringBuilder);
        return n;
    }

    private static StringBuffer getBuf() {
        return buf.get();
    }

    private static native void initIDs();

    public static native boolean isSupported();

    public static native int offlineFilter(PcapBpfProgram var0, int var1, int var2, ByteBuffer var3);

    public static native int offlineFilter(PcapBpfProgram var0, PcapHeader var1, ByteBuffer var2);

    public static native int offlineFilter(PcapBpfProgram var0, PcapHeader var1, JBuffer var2);

    @Deprecated
    public static native int offlineFilter(PcapBpfProgram var0, PcapPktHdr var1, ByteBuffer var2);

    public static WinPcap open(String string, int n, int n2, int n3, WinPcapRmtAuth winPcapRmtAuth, Appendable appendable) throws IOException {
        WinPcap winPcap = WinPcap.open(string, n, n2, n3, winPcapRmtAuth, WinPcap.getBuf());
        WinPcap.toAppendable(WinPcap.getBuf(), appendable);
        return winPcap;
    }

    public static native WinPcap open(String var0, int var1, int var2, int var3, WinPcapRmtAuth var4, StringBuffer var5);

    public static WinPcap open(String string, int n, int n2, int n3, WinPcapRmtAuth winPcapRmtAuth, StringBuilder stringBuilder) {
        WinPcap winPcap = WinPcap.open(string, n, n2, n3, winPcapRmtAuth, WinPcap.getBuf());
        WinPcap.toStringBuilder(WinPcap.getBuf(), stringBuilder);
        return winPcap;
    }

    public static native WinPcap openDead(int var0, int var1);

    public static WinPcap openLive(String string, int n, int n2, int n3, Appendable appendable) throws IOException {
        WinPcap winPcap = WinPcap.openLive(string, n, n2, n3, WinPcap.getBuf());
        WinPcap.toAppendable(WinPcap.getBuf(), appendable);
        return winPcap;
    }

    public static native WinPcap openLive(String var0, int var1, int var2, int var3, StringBuffer var4);

    public static WinPcap openLive(String string, int n, int n2, int n3, StringBuilder stringBuilder) {
        WinPcap winPcap = WinPcap.openLive(string, n, n2, n3, WinPcap.getBuf());
        WinPcap.toStringBuilder(WinPcap.getBuf(), stringBuilder);
        return winPcap;
    }

    public static WinPcap openOffline(String string, Appendable appendable) throws IOException {
        WinPcap winPcap = WinPcap.openOffline(string, WinPcap.getBuf());
        WinPcap.toAppendable(WinPcap.getBuf(), appendable);
        return winPcap;
    }

    public static native WinPcap openOffline(String var0, StringBuffer var1);

    public static WinPcap openOffline(String string, StringBuilder stringBuilder) {
        WinPcap winPcap = WinPcap.openOffline(string, WinPcap.getBuf());
        WinPcap.toStringBuilder(WinPcap.getBuf(), stringBuilder);
        return winPcap;
    }

    public static WinPcapSendQueue sendQueueAlloc(int n) {
        if (!WinPcap.isSupported()) {
            throw new PcapExtensionNotAvailableException();
        }
        return new WinPcapSendQueue(n);
    }

    public static void sendQueueDestroy(WinPcapSendQueue winPcapSendQueue) {
        if (!WinPcap.isSupported()) {
            throw new PcapExtensionNotAvailableException();
        }
    }

    private static void toAppendable(StringBuffer stringBuffer, Appendable appendable) throws IOException {
        if (stringBuffer.length() != 0) {
            appendable.append(stringBuffer);
        }
    }

    private static void toStringBuilder(StringBuffer stringBuffer, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        if (stringBuffer.length() != 0) {
            stringBuilder.append(stringBuffer);
        }
    }

    private WinPcap() {
    }

    public native int liveDump(String var1, int var2, int var3);

    public native int liveDumpEnded(int var1);

    public native int sendQueueTransmit(WinPcapSendQueue var1, int var2);

    public native int setBuff(int var1);

    public native int setMinToCopy(int var1);

    public native int setMode(int var1);

    public native WinPcapSamp setSampling();

    public native WinPcapStat statsEx();

    static {
        WinPcap.initIDs();
        try {
            Class.forName("org.jnetpcap.winpcap.WinPcapStat");
            Class.forName("org.jnetpcap.winpcap.WinPcapSamp");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find class: ", classNotFoundException);
        }
    }
}

