/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.structure.AnnotatedMethod;
import org.jnetpcap.packet.structure.AnnotatedMethodException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedHeaderLengthMethod
extends AnnotatedMethod {
    private static final Map<Class<?>, AnnotatedHeaderLengthMethod[]> cache = new HashMap();
    private int staticLength;
    private final HeaderLength.Type type;

    public static AnnotatedHeaderLengthMethod[] inspectClass(Class<? extends JHeader> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        AnnotatedHeaderLengthMethod[] annotatedHeaderLengthMethodArray = new AnnotatedHeaderLengthMethod[HeaderLength.Type.values().length];
        Header header = clazz.getAnnotation(Header.class);
        if (header != null && header.length() != -1) {
            annotatedHeaderLengthMethodArray[HeaderLength.Type.HEADER.ordinal()] = new AnnotatedHeaderLengthMethod(clazz, header.length(), HeaderLength.Type.HEADER);
        }
        if (header != null && header.prefix() != -1) {
            annotatedHeaderLengthMethodArray[HeaderLength.Type.PREFIX.ordinal()] = new AnnotatedHeaderLengthMethod(clazz, header.prefix(), HeaderLength.Type.PREFIX);
        }
        if (header != null && header.gap() != -1) {
            annotatedHeaderLengthMethodArray[HeaderLength.Type.GAP.ordinal()] = new AnnotatedHeaderLengthMethod(clazz, header.gap(), HeaderLength.Type.GAP);
        }
        if (header != null && header.payload() != -1) {
            annotatedHeaderLengthMethodArray[HeaderLength.Type.PAYLOAD.ordinal()] = new AnnotatedHeaderLengthMethod(clazz, header.payload(), HeaderLength.Type.PAYLOAD);
        }
        if (header != null && header.postfix() != -1) {
            annotatedHeaderLengthMethodArray[HeaderLength.Type.POSTFIX.ordinal()] = new AnnotatedHeaderLengthMethod(clazz, header.postfix(), HeaderLength.Type.POSTFIX);
        }
        for (Method method : AnnotatedHeaderLengthMethod.getMethods(clazz, HeaderLength.class)) {
            HeaderLength headerLength = method.getAnnotation(HeaderLength.class);
            if (annotatedHeaderLengthMethodArray[headerLength.value().ordinal()] != null) {
                throw new AnnotatedMethodException(clazz, "duplicate: " + annotatedHeaderLengthMethodArray[headerLength.value().ordinal()] + " property and " + method.getName() + "() method");
            }
            AnnotatedHeaderLengthMethod.checkSignature(method);
            annotatedHeaderLengthMethodArray[headerLength.value().ordinal()] = new AnnotatedHeaderLengthMethod(method, headerLength.value());
        }
        if (annotatedHeaderLengthMethodArray[HeaderLength.Type.HEADER.ordinal()] == null) {
            throw new AnnotatedMethodException(clazz, "@HeaderLength annotated method not found");
        }
        cache.put(clazz, annotatedHeaderLengthMethodArray);
        return annotatedHeaderLengthMethodArray;
    }

    private AnnotatedHeaderLengthMethod(Method method, HeaderLength.Type type) {
        super(method);
        this.type = type;
        this.staticLength = -1;
    }

    public AnnotatedHeaderLengthMethod(Class<? extends JHeader> clazz, int n, HeaderLength.Type type) {
        this.staticLength = n;
        this.type = type;
    }

    public int getHeaderLength(JBuffer jBuffer, int n) {
        if (this.staticLength != -1) {
            return this.staticLength;
        }
        try {
            int n2 = (Integer)this.method.invoke(null, jBuffer, n);
            return n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AnnotatedMethodException(this.declaringClass, invocationTargetException.getCause());
        }
    }

    @Override
    public final Method getMethod() {
        return this.method;
    }

    public boolean hasStaticLength() {
        return this.staticLength != -1;
    }

    @Override
    protected void validateSignature(Method method) {
        AnnotatedHeaderLengthMethod.checkSignature(method);
    }

    private static void checkSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (!method.isAnnotationPresent(HeaderLength.class)) {
            throw new AnnotatedMethodException(clazz, "@HeaderLength annotation missing for " + method.getName() + "()");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 2 || classArray[0] != JBuffer.class || classArray[1] != Integer.TYPE || method.getReturnType() != Integer.TYPE) {
            throw new AnnotatedMethodException(clazz, "Invalid signature for " + method.getName() + "()");
        }
        if ((method.getModifiers() & 8) == 0) {
            throw new AnnotatedMethodException(clazz, method.getName() + "()" + " must be declared static");
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    @Override
    public String toString() {
        if (this.method == null) {
            String string = this.type == HeaderLength.Type.HEADER ? "length" : this.type.toString().toLowerCase();
            return "@Header(" + string + "=" + this.staticLength + ")";
        }
        return super.toString();
    }
}

