/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.structure.AnnotatedMethod;
import org.jnetpcap.packet.structure.AnnotatedMethodException;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedBindMethod
extends AnnotatedMethod {
    private static final Map<Class<?>, AnnotatedBindMethod[]> cache = new HashMap();

    private static void checkSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (!method.isAnnotationPresent(Bind.class)) {
            throw new AnnotatedMethodException(clazz, "@Bind annotation missing for " + method.getName() + "()");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 2 || classArray[0] != JPacket.class || classArray[1].isAssignableFrom(JHeader.class)) {
            throw new AnnotatedMethodException(clazz, "Invalid signature for " + method.getName() + "()");
        }
        if ((method.getModifiers() & 8) == 0) {
            throw new AnnotatedMethodException(clazz, method.getName() + "()" + " must be declared static");
        }
    }

    private static void checkNonStaticSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (!method.isAnnotationPresent(Bind.class)) {
            throw new AnnotatedMethodException(clazz, "@Bind annotation missing for " + method.getName() + "()");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 2 || classArray[0] != JPacket.class || classArray[1].isAssignableFrom(JHeader.class)) {
            throw new AnnotatedMethodException(clazz, "Invalid signature for " + method.getName() + "()");
        }
        if ((method.getModifiers() & 8) != 0) {
            throw new AnnotatedMethodException(clazz, method.getName() + "()" + " can not be declared static");
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    public static AnnotatedBindMethod[] inspectClass(Class<?> clazz, List<HeaderDefinitionError> list) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        AnnotatedBindMethod[] annotatedBindMethodArray = AnnotatedBindMethod.inspectAnyClass(clazz, list);
        LinkedList<AnnotatedBindMethod> linkedList = new LinkedList<AnnotatedBindMethod>(Arrays.asList(annotatedBindMethodArray));
        AnnotatedBindMethod[] annotatedBindMethodArray2 = linkedList.iterator();
        while (annotatedBindMethodArray2.hasNext()) {
            AnnotatedBindMethod annotatedBindMethod = (AnnotatedBindMethod)annotatedBindMethodArray2.next();
            Bind bind = annotatedBindMethod.getMethod().getAnnotation(Bind.class);
            Class<? extends JHeader> clazz2 = bind.from();
            if (clazz2 != JHeader.class) continue;
            list.add(new HeaderDefinitionError(clazz, "missing annotated 'from' declaration for method " + annotatedBindMethod.getMethod().getName() + "()"));
            annotatedBindMethodArray2.remove();
        }
        annotatedBindMethodArray2 = linkedList.toArray(new AnnotatedBindMethod[linkedList.size()]);
        cache.put(clazz, annotatedBindMethodArray2);
        return annotatedBindMethodArray2;
    }

    private static <T extends JHeader> AnnotatedBindMethod[] inspectAnyClass(Class<?> clazz, List<HeaderDefinitionError> list) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        ArrayList<AnnotatedBindMethod> arrayList = new ArrayList<AnnotatedBindMethod>();
        Class<? extends JHeader> clazz2 = null;
        for (Method method : clazz.getMethods()) {
            try {
                if (!method.isAnnotationPresent(Bind.class)) continue;
                AnnotatedBindMethod.checkSignature(method);
                Bind bind = method.getAnnotation(Bind.class);
                clazz2 = bind.to();
                AnnotatedBindMethod annotatedBindMethod = new AnnotatedBindMethod(clazz2, method);
                arrayList.add(annotatedBindMethod);
            }
            catch (AnnotatedMethodException annotatedMethodException) {
                list.add(annotatedMethodException);
            }
        }
        Object[] objectArray = arrayList.toArray(new AnnotatedBindMethod[arrayList.size()]);
        cache.put(clazz, (AnnotatedBindMethod[])objectArray);
        return objectArray;
    }

    public static AnnotatedBindMethod[] inspectObject(Object object, List<HeaderDefinitionError> list) {
        Class<?> clazz = object.getClass();
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        ArrayList<AnnotatedBindMethod> arrayList = new ArrayList<AnnotatedBindMethod>();
        Class<? extends JHeader> clazz2 = null;
        if (clazz.getSuperclass() != Object.class) {
            list.add(new AnnotatedMethodException("bindings using annonymous classes can only extend Object class"));
            return new AnnotatedBindMethod[0];
        }
        for (Method method : clazz.getMethods()) {
            try {
                if (!method.isAnnotationPresent(Bind.class)) continue;
                AnnotatedBindMethod.checkNonStaticSignature(method);
                Bind bind = method.getAnnotation(Bind.class);
                clazz2 = bind.to();
                AnnotatedBindMethod annotatedBindMethod = new AnnotatedBindMethod(clazz2, method, object);
                arrayList.add(annotatedBindMethod);
            }
            catch (AnnotatedMethodException annotatedMethodException) {
                list.add(annotatedMethodException);
            }
        }
        Object[] objectArray = arrayList.toArray(new AnnotatedBindMethod[arrayList.size()]);
        cache.put(clazz, (AnnotatedBindMethod[])objectArray);
        return objectArray;
    }

    public static <T extends JHeader> AnnotatedBindMethod[] inspectJHeaderClass(Class<? extends JHeader> clazz, List<HeaderDefinitionError> list) {
        return AnnotatedBindMethod.inspectAnyClass(clazz, list);
    }

    private AnnotatedBindMethod(Class<? extends JHeader> clazz, Method method, Object object) {
        super(method, object);
    }

    private AnnotatedBindMethod(Class<? extends JHeader> clazz, Method method) {
        super(method);
    }

    public boolean isBound(JPacket jPacket, int n, JHeader jHeader) {
        try {
            return (Boolean)this.method.invoke(this.object, jPacket, jHeader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AnnotatedMethodException(this.declaringClass, (Throwable)invocationTargetException);
        }
    }

    @Override
    protected void validateSignature(Method method) {
        if (this.object == null) {
            AnnotatedBindMethod.checkSignature(method);
        } else {
            AnnotatedBindMethod.checkNonStaticSignature(method);
        }
    }
}

