/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.format;

import java.io.IOException;
import java.util.Formatter;
import java.util.Stack;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderPool;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.UnregisteredHeaderException;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.packet.format.XmlFormatter;
import org.jnetpcap.packet.structure.JField;
import org.jnetpcap.util.resolver.Resolver;

public abstract class JFormatter {
    private static final Detail DEFAULT_DETAIL = Detail.MULTI_LINE_FULL_DETAIL;
    private static boolean defaultDisplayPayload = true;
    private static boolean defaultResolveAddresses = false;
    private static JFormatter global;
    private Detail[] detailsPerHeader = new Detail[64];
    private boolean displayPayload;
    protected int frameIndex = -1;
    private JHeaderPool headers = new JHeaderPool();
    private Resolver ipResolver;
    private int level;
    private Resolver ouiPrefixResolver;
    protected Formatter out;
    private StringBuilder outputBuffer;
    private Stack<String> padStack = new Stack();
    private boolean resolveAddresses = false;

    public static JFormatter getDefault() {
        if (global == null) {
            global = new XmlFormatter();
        }
        return global;
    }

    public static void setDefault(JFormatter jFormatter) {
        global = jFormatter;
    }

    public static void setDefaultDisplayPayload(boolean bl) {
        defaultDisplayPayload = bl;
    }

    public static void setDefaultResolveAddress(boolean bl) {
        defaultResolveAddresses = bl;
    }

    public JFormatter() {
        this.setDetail(DEFAULT_DETAIL);
        this.setOutput(System.out);
        this.setResolveAddresses(defaultResolveAddresses);
        this.setDisplayPayload(defaultDisplayPayload);
    }

    public JFormatter(Appendable appendable) {
        this.setDetail(DEFAULT_DETAIL);
        this.setOutput(appendable);
        this.setResolveAddresses(defaultResolveAddresses);
        this.setDisplayPayload(defaultDisplayPayload);
    }

    public JFormatter(StringBuilder stringBuilder) {
        this.setDetail(DEFAULT_DETAIL);
        this.setOutput(stringBuilder);
        this.setResolveAddresses(defaultResolveAddresses);
        this.setDisplayPayload(defaultDisplayPayload);
    }

    protected void decLevel() {
        if (this.level == 0) {
            return;
        }
        --this.level;
        this.padStack.pop();
    }

    protected abstract void fieldAfter(JHeader var1, JField var2, Detail var3) throws IOException;

    protected abstract void fieldBefore(JHeader var1, JField var2, Detail var3) throws IOException;

    protected void fieldNull(JHeader jHeader, JField jField, Detail detail) {
    }

    public void format(JHeader jHeader) throws IOException {
        this.format(jHeader, DEFAULT_DETAIL);
    }

    public void format(JHeader jHeader, Detail detail) throws IOException {
        if (jHeader == null) {
            this.headerNull(jHeader, detail);
            return;
        }
        JField[] jFieldArray = jHeader.getFields();
        this.headerBefore(jHeader, detail);
        for (JField object : jFieldArray) {
            if (!object.hasField(jHeader)) continue;
            this.format(jHeader, object, detail);
        }
        for (JHeader jHeader2 : jHeader.getSubHeaders()) {
            this.format(jHeader, jHeader2, detail);
        }
        this.headerAfter(jHeader, detail);
    }

    public void format(JHeader jHeader, JField jField) throws IOException {
        this.format(jHeader, jField, DEFAULT_DETAIL);
    }

    public void format(JHeader jHeader, JField jField, Detail detail) throws IOException {
        if (jHeader == null) {
            this.headerNull(jHeader, detail);
            return;
        }
        if (jField == null) {
            this.fieldNull(jHeader, jField, detail);
            return;
        }
        this.fieldBefore(jHeader, jField, detail);
        if (jField.hasSubFields()) {
            for (JField jField2 : jField.getSubFields()) {
                this.format(jHeader, jField2, detail);
            }
        }
        this.fieldAfter(jHeader, jField, detail);
    }

    public void format(JHeader jHeader, JHeader jHeader2, Detail detail) throws IOException {
        JField[] jFieldArray = jHeader2.getFields();
        this.subHeaderBefore(jHeader, jHeader2, detail);
        for (JField jField : jFieldArray) {
            if (jField == null || !detail.isDisplayable(jField.getPriority()) || !jField.hasField(jHeader)) continue;
            this.format(jHeader2, jField, detail);
        }
        this.subHeaderAfter(jHeader, jHeader2, detail);
    }

    public void format(JPacket jPacket) throws IOException {
        this.format(jPacket, DEFAULT_DETAIL);
    }

    public void format(JPacket jPacket, Detail detail) throws IOException {
        if (jPacket == null) {
            this.packetNull(jPacket, detail);
            return;
        }
        this.packetBefore(jPacket, detail);
        int n = jPacket.getHeaderCount();
        for (int i = 0; i < n; ++i) {
            int n2 = jPacket.getHeaderIdByIndex(i);
            if (n2 == 0 && !this.displayPayload) continue;
            try {
                JHeader jHeader = this.headers.getHeader(n2);
                Detail detail2 = this.detailsPerHeader[n2] == null ? detail : this.detailsPerHeader[n2];
                jPacket.getHeaderByIndex(i, jHeader);
                if (jHeader.getLength() == 0) continue;
                this.format(jHeader, detail2);
                continue;
            }
            catch (UnregisteredHeaderException unregisteredHeaderException) {
                throw new IllegalStateException(unregisteredHeaderException);
            }
        }
        this.packetAfter(jPacket, detail);
    }

    public void format(StringBuilder stringBuilder, JPacket jPacket) {
        try {
            this.format(jPacket, DEFAULT_DETAIL);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private String formatIpAddress(byte[] byArray) {
        if (this.resolveAddresses) {
            return this.resolveIp(byArray);
        }
        return byArray.length == 16 ? FormatUtils.asStringIp6(byArray, true) : FormatUtils.asString(byArray, '.', 10).toUpperCase();
    }

    private String formatMacAddress(byte[] byArray) {
        String string = FormatUtils.mac(byArray).toLowerCase();
        if (this.resolveAddresses && this.ouiPrefixResolver.canBeResolved(byArray)) {
            String string2 = this.ouiPrefixResolver.resolve(byArray);
            String string3 = string2 + "_" + FormatUtils.asStringZeroPad(byArray, ':', 16, 3, 3).toLowerCase();
            return string3 + " (" + string + ")";
        }
        return string;
    }

    protected abstract void headerAfter(JHeader var1, Detail var2) throws IOException;

    protected abstract void headerBefore(JHeader var1, Detail var2) throws IOException;

    protected void headerNull(JHeader jHeader, Detail detail) {
    }

    protected void incLevel(int n) {
        this.incLevel(n, ' ');
    }

    protected void incLevel(int n, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(c);
        }
        this.incLevel(stringBuilder.toString());
    }

    protected void incLevel(String string) {
        ++this.level;
        this.padStack.push(string);
    }

    public abstract void packetAfter(JPacket var1, Detail var2) throws IOException;

    public abstract void packetBefore(JPacket var1, Detail var2) throws IOException;

    protected void packetNull(JPacket jPacket, Detail detail) {
    }

    protected Formatter pad() {
        this.out.format("\n", new Object[0]);
        for (String string : this.padStack) {
            this.out.format(String.valueOf(string), new Object[0]);
        }
        return this.out;
    }

    public void reset() {
        if (this.outputBuffer != null) {
            this.outputBuffer.setLength(0);
        }
        this.padStack.clear();
    }

    private String resolveIp(byte[] byArray) {
        String string = byArray.length == 16 ? FormatUtils.asStringIp6(byArray, true) : FormatUtils.asString(byArray, '.', 10).toUpperCase();
        String string2 = this.ipResolver.resolve(byArray);
        if (string2 == null) {
            return string + " (resolve failed)";
        }
        return string + " (" + string2 + ")";
    }

    public void setDetail(Detail detail) {
        for (int i = 0; i < 64; ++i) {
            this.detailsPerHeader[i] = detail;
        }
    }

    public void setDetail(Detail detail, int n) {
        this.detailsPerHeader[n] = detail;
    }

    public void setDisplayPayload(boolean bl) {
        this.displayPayload = bl;
    }

    public void setFrameIndex(int n) {
        this.frameIndex = n;
    }

    public void setOutput(Appendable appendable) {
        this.out = new Formatter(appendable);
        this.outputBuffer = null;
    }

    public void setOutput(StringBuilder stringBuilder) {
        this.outputBuffer = stringBuilder;
        this.out = new Formatter(stringBuilder);
    }

    public void setResolveAddresses(boolean bl) {
        this.resolveAddresses = bl;
        if (bl && this.ouiPrefixResolver == null) {
            this.ouiPrefixResolver = JRegistry.getResolver(Resolver.ResolverType.IEEE_OUI_PREFIX);
            this.ipResolver = JRegistry.getResolver(Resolver.ResolverType.IP);
        } else {
            this.ouiPrefixResolver = null;
            this.ipResolver = null;
        }
    }

    private String stylizeBitField(JHeader jHeader, JField jField, Object object) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        JField jField2 = jField.getParent();
        int n2 = jField2.getLength(jHeader);
        long l = jField2.getMask(jHeader);
        long l2 = jField.longValue(jHeader);
        int n3 = jField.getOffset(jHeader);
        int n4 = jField.getLength(jHeader);
        int n5 = n3 + n4;
        int n6 = n3;
        for (n = n2; n > n5; --n) {
            if ((l & 1L << n - 1) == 0L) continue;
            stringBuilder.append((n - 1) % 4 == 0 ? ". " : Character.valueOf('.'));
        }
        for (n = n5; n > n6; --n) {
            if ((l & 1L << n - 1) == 0L) continue;
            if ((l2 & 1L << n - n6 - 1) == 0L) {
                stringBuilder.append('0');
            } else {
                stringBuilder.append('1');
            }
            if ((n - 1) % 4 != 0) continue;
            stringBuilder.append(' ');
        }
        for (n = n6; n > 0; --n) {
            if ((l & 1L << n - 1) == 0L) continue;
            stringBuilder.append((n - 1) % 4 == 0 ? ". " : Character.valueOf('.'));
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    protected String[] stylizeMultiLine(JHeader jHeader, JField jField, Object object) {
        return this.stylizeMultiLine(jHeader, jField, jField.getStyle(), object);
    }

    protected String[] stylizeMultiLine(JHeader jHeader, JField jField, Style style, Object object) {
        switch (style) {
            case BYTE_ARRAY_HEX_DUMP: {
                return FormatUtils.hexdump((byte[])object, jHeader.getOffset(), 0, true, true, true);
            }
            case BYTE_ARRAY_HEX_DUMP_NO_TEXT: {
                return FormatUtils.hexdump((byte[])object, jHeader.getOffset(), 0, true, false, true);
            }
            case BYTE_ARRAY_HEX_DUMP_NO_TEXT_ADDRESS: {
                return FormatUtils.hexdump((byte[])object, jHeader.getOffset(), 0, false, false, true);
            }
            case BYTE_ARRAY_HEX_DUMP_NO_ADDRESS: {
                return FormatUtils.hexdump((byte[])object, jHeader.getOffset(), 0, false, true, true);
            }
            case BYTE_ARRAY_HEX_DUMP_ADDRESS: {
                return FormatUtils.hexdump((byte[])object, jHeader.getOffset(), 0, true, false, false);
            }
            case BYTE_ARRAY_HEX_DUMP_TEXT: {
                return FormatUtils.hexdump((byte[])object, jHeader.getOffset(), 0, false, true, false);
            }
            case STRING_TEXT_DUMP: {
                return ((String)object).split("\r\n");
            }
        }
        return new String[]{this.stylizeSingleLine(jHeader, jField, object)};
    }

    protected String stylizeSingleLine(JHeader jHeader, JField jField, Object object) {
        Style style = jField.getStyle();
        switch (style) {
            case BYTE_ARRAY_DASH_ADDRESS: {
                return FormatUtils.asString((byte[])object, '-').toUpperCase();
            }
            case BYTE_ARRAY_COLON_ADDRESS: {
                return this.formatMacAddress((byte[])object);
            }
            case BYTE_ARRAY_DOT_ADDRESS: {
                return FormatUtils.asString((byte[])object, '.').toUpperCase();
            }
            case BYTE_ARRAY_ARRAY_IP4_ADDRESS: 
            case BYTE_ARRAY_IP4_ADDRESS: 
            case BYTE_ARRAY_IP6_ADDRESS: {
                return this.formatIpAddress((byte[])object);
            }
            case INT_BITS: {
                return this.stylizeBitField(jHeader, jField, object);
            }
            case INT_RADIX_16: {
                return Long.toHexString(((Number)object).longValue()).toUpperCase();
            }
            case INT_HEX: {
                return "0x" + Long.toHexString(((Number)object).longValue()).toUpperCase() + " (" + object.toString() + ")";
            }
            case LONG_HEX: {
                return "0x" + Long.toHexString((Long)object).toUpperCase() + " (" + object.toString() + ")";
            }
        }
        return object.toString();
    }

    protected abstract void subHeaderAfter(JHeader var1, JHeader var2, Detail var3) throws IOException;

    protected abstract void subHeaderBefore(JHeader var1, JHeader var2, Detail var3) throws IOException;

    public String toString() {
        return this.out.toString();
    }

    public void println(String string) {
        this.out.format("%s\n", string);
    }

    public void printf(String string, Object ... objectArray) {
        this.out.format(string, objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BYTE_ARRAY_ARRAY_IP4_ADDRESS,
        BYTE_ARRAY_COLON_ADDRESS,
        BYTE_ARRAY_DASH_ADDRESS,
        BYTE_ARRAY_DOT_ADDRESS,
        BYTE_ARRAY_HEX_DUMP,
        BYTE_ARRAY_HEX_DUMP_ADDRESS,
        BYTE_ARRAY_HEX_DUMP_NO_ADDRESS,
        BYTE_ARRAY_HEX_DUMP_NO_TEXT,
        BYTE_ARRAY_HEX_DUMP_NO_TEXT_ADDRESS,
        BYTE_ARRAY_HEX_DUMP_TEXT,
        BYTE_ARRAY_IP4_ADDRESS,
        BYTE_ARRAY_IP6_ADDRESS,
        INT_BIN,
        INT_BITS,
        INT_DEC,
        INT_HEX,
        INT_OCT,
        INT_RADIX_10,
        INT_RADIX_16,
        INT_RADIX_2,
        INT_RADIX_8,
        LONG_DEC,
        LONG_HEX,
        STRING,
        STRING_TEXT_DUMP,
        BOOLEAN,
        STRING_ARRAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        HIGH,
        LOW,
        MEDIUM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Detail {
        MULTI_LINE_FULL_DETAIL{

            public boolean isDisplayable(Priority priority) {
                return true;
            }
        }
        ,
        MULTI_LINE_SUMMARY{

            public boolean isDisplayable(Priority priority) {
                return priority == Priority.MEDIUM || priority == Priority.HIGH;
            }
        }
        ,
        NONE{

            public boolean isDisplayable(Priority priority) {
                return false;
            }
        }
        ,
        ONE_LINE_SUMMARY{

            public boolean isDisplayable(Priority priority) {
                return priority == Priority.HIGH;
            }
        };


        public abstract boolean isDisplayable(Priority var1);
    }
}

