/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.crypto;

import java.security.MessageDigest;
import java.security.Security;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Digest {

	private static Digest instance;

	private Digest() {
		Security.addProvider(new BouncyCastleProvider());
	}

	public static Digest getInstance() {

		if (instance == null)
			instance = new Digest();

		return instance;
	}

	public byte[] sha256(byte[] msg) {

		return hash("SHA256", msg);
	}

	private static byte[] hash(String algorithm, byte[] msg) {

		Security.addProvider(new BouncyCastleProvider());

		MessageDigest digest;
		try {
			digest = MessageDigest.getInstance(algorithm.toUpperCase(), "BC");
			digest.update(msg);
			return digest.digest();
		} catch (Exception e) {
			return new byte[0];
		}
	}

	/**
	 * @param msg
	 * @return
	 * @throws CryptoUtilsException
	 */
	public byte[] sha1(byte[] msg) {
		return hash("SHA1", msg);
	}
}
