#ifndef UpperTesterIvim_LAYER_H
#define UpperTesterIvim_LAYER_H

#include "t_layer.hh"
#include "UpperTesterIvimCodec.hh"

namespace LibItsIvim__TestSystem {
  class UpperTesterPort;
}

namespace LibItsIvim__TypesAndValues {
  class UtIvimInitialize;
  class UtIvimTrigger;
  class UtIvimUpdate;
  class UtIvimTermination;
}

class UpperTesterIvimLayer : public t_layer<LibItsIvim__TestSystem::UpperTesterPort> {
  Params _params;
  UpperTesterIvimCodec _codec;
  
public:
  UpperTesterIvimLayer() : t_layer<LibItsIvim__TestSystem::UpperTesterPort>(), _params(), _codec() {};
  UpperTesterIvimLayer(const std::string & p_type, const std::string & param);
  virtual ~UpperTesterIvimLayer() {};

  void sendMsg(const LibItsIvim__TypesAndValues::UtIvimInitialize& send_par, Params& params);
  void sendMsg(const LibItsIvim__TypesAndValues::UtIvimTrigger& send_par, Params& params);
  void sendMsg(const LibItsIvim__TypesAndValues::UtIvimUpdate& send_par, Params& params);
  void sendMsg(const LibItsIvim__TypesAndValues::UtIvimTermination& send_par, Params& params);
  
  virtual void send_data(OCTETSTRING& data, Params& params);
  virtual void receive_data(OCTETSTRING& data, Params& info);
};

#endif
