#include "UpperTesterCamFactory.hh"

#include "UpperTesterTypes.hh"

#include "loggers.hh"

UpperTesterCamLayer::UpperTesterCamLayer(const std::string & p_type, const std::string & param) : t_layer<LibItsCam__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterCamLayer::UpperTesterCamLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  Params::convert(_params, param);
}

void UpperTesterCamLayer::sendMsg(const LibItsCam__TypesAndValues::UtCamInitialize& send_par, Params& params){
  loggers::get_instance().log_msg(">>> UpperTesterCamLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterCamLayer::sendMsg(const LibItsCam__TypesAndValues::UtCamChangePosition& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterCamLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterCamLayer::sendMsg(const LibItsCam__TypesAndValues::UtCamTrigger& send_par, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterCamLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  send_data(data, params);
}

void UpperTesterCamLayer::send_data(OCTETSTRING& data, Params& params) {
  loggers::get_instance().log_msg(">>> UpperTesterCamLayer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, params);
}

void UpperTesterCamLayer::receive_data(OCTETSTRING& data, Params& params)
{
  loggers::get_instance().log_msg(">>> UpperTesterCamLayer::receive_data: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    to_all_upper_ports(*r, params);
  }
}

UpperTesterCamFactory UpperTesterCamFactory::_f;
