#ifndef SSEMCODEC_H
#define SSEMCODEC_H

#include "Codec.hh"
#include "per_code.hh"
#include "Params.hh"

#include "LibItsSremSsem_TestSystem.hh"

class SsemPDUCodec : public per_code <SSEM__PDU__Descriptions::SSEM>
{
public:
  SsemPDUCodec() { };
  virtual int encode (const SSEM__PDU__Descriptions::SSEM& ssem, BITSTRING& data);
  virtual int decode (const BITSTRING& data, SSEM__PDU__Descriptions::SSEM&);
};

class SsemCodec : public Codec<SSEM__PDU__Descriptions::SSEM, SSEM__PDU__Descriptions::SSEM>
{
  SsemPDUCodec asnCodec;

public:
  SsemCodec() : Codec<SSEM__PDU__Descriptions::SSEM, SSEM__PDU__Descriptions::SSEM>(), asnCodec() { };
  virtual ~SsemCodec() { };

  virtual int encode (const SSEM__PDU__Descriptions::SSEM& ssem, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, SSEM__PDU__Descriptions::SSEM&, Params* params = NULL);
};

#endif
