#include "EtsiTs103097Module.hh"

#include "EtsiTs103097Codec_ToBeSignedData.hh"
#include "asn1/asn_application.h" // from asn1c
#include "asn1/EtsiTs103097Data.h"

#include "loggers.hh"

int EtsiTs103097Codec_ToBeSignedData::encode (const IEEE1609dot2::ToBeSignedData& p_cert, OCTETSTRING& data)
{
  loggers::get_instance().log(">>> EtsiTs103097Codec_ToBeSignedData::encode: %s", p_cert.get_descriptor()->name);
  
  BITSTRING b;
  TTCN_EncDec::clear_error();
  TTCN_Buffer buffer;
  p_cert.encode(*p_cert.get_descriptor(), buffer, TTCN_EncDec::CT_OER);
  data = OCTETSTRING(buffer.get_len(), buffer.get_data());
  loggers::get_instance().log_msg("EtsiTs103097Codec_ToBeSignedData::encode: ", data);

  return 0;
}

int EtsiTs103097Codec_ToBeSignedData::decode (const OCTETSTRING& data, IEEE1609dot2::ToBeSignedData& p_cert, Params* params)
{
  loggers::get_instance().log_msg(">>> EtsiTs103097Codec_ToBeSignedData::decode: ", data);

  TTCN_EncDec::clear_error();
  TTCN_Buffer decoding_buffer(data);
  _params = params;
  p_cert.decode(*p_cert.get_descriptor(), decoding_buffer, TTCN_EncDec::CT_OER);
  
  loggers::get_instance().log_msg("<<< EtsiTs103097Codec_ToBeSignedData::decode: ", (const Base_Type&)p_cert);
  return 0;
}

// extern "C" {
//   extern asn_TYPE_descriptor_t asn_DEF_EtsiTs103097;
// }

// int EtsiTs103097PDUCodec::encode (const IEEE1609dot2::ToBeSignedData& p_cert, BITSTRING& p_data)
// {
//   return _encode(IEEE1609dot2::ToBeSignedData_descr_, asn_DEF_EtsiTs103097Data, p_cert, p_data);
// }

// int EtsiTs103097PDUCodec::decode (const BITSTRING& p_data, IEEE1609dot2::ToBeSignedData& p_cert)
// {
//   return _decode(IEEE1609dot2::ToBeSignedData_descr_, asn_DEF_EtsiTs103097Data, p_data, p_cert);
// }
