/*!
 * \file      MapemSpatemLayer.hh
 * \brief     Header file for ITS MapemSpatem protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "t_layer.hh"
#include "MapemCodec.hh"
#include "SpatemCodec.hh"

namespace LibItsMapemSpatem__TestSystem {
  class MapemSpatemPort;
  class MapemReq;
  class MapemInd;
  class SpatemReq;
  class SpatemInd;
}

class MapemSpatemLayer : public t_layer<LibItsMapemSpatem__TestSystem::MapemSpatemPort> {
  Params _params;
  MapemCodec _mapem_codec;
  SpatemCodec _spatem_codec;
public:
  MapemSpatemLayer() : t_layer<LibItsMapemSpatem__TestSystem::MapemSpatemPort>(), _params(), _mapem_codec(), _spatem_codec() {};
  MapemSpatemLayer(const std::string& p_type, const std::string& param);
  virtual ~MapemSpatemLayer() {};

  void sendMsg(const LibItsMapemSpatem__TestSystem::MapemReq&, Params& params);
  void sendMsg(const LibItsMapemSpatem__TestSystem::SpatemReq&, Params& params);
  
  virtual void send_data(OCTETSTRING& data, Params& params);
  virtual void receive_data(OCTETSTRING& data, Params& info);
}; // End of class MapemSpatemLayer

