/*!
 * \file      IVIMLayerFactory.hh
 * \brief     Header file for ITS IVIM protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "layer_stack_builder.hh"

#include "IVIMLayer.hh"

class IVIMLayerFactory : public layer_factory {
  static IVIMLayerFactory _f;
public:
  IVIMLayerFactory() {
    // Register factory
    layer_stack_builder::register_layer_factory("IVIM", this);
  };
  inline virtual layer* create_layer(const std::string& p_type, const std::string& p_param){
    return new IVIMLayer(p_type, p_param);
  };
}; // End of class IVIMLayerFactory

