/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import org.jnetpcap.JCaptureHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JStruct;

public class PcapHeader
extends JStruct
implements JCaptureHeader {
    public static final String STRUCT_NAME = "pcap_pkthdr";
    public static final int LENGTH = 16;

    public static native int sizeof();

    public PcapHeader() {
        super(STRUCT_NAME, 16);
    }

    public PcapHeader(int n, int n2) {
        super(STRUCT_NAME, 16);
        this.hdr_len(n);
        this.hdr_wirelen(n2);
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        long l3 = (l - l2 * 1000L) * 1000L;
        this.hdr_sec(l2);
        this.hdr_usec((int)l3);
    }

    public PcapHeader(JMemory.Type type) {
        super(STRUCT_NAME, type);
    }

    public int caplen() {
        return this.hdr_len();
    }

    public native int hdr_len();

    public native void hdr_len(int var1);

    public native long hdr_sec();

    public native void hdr_sec(long var1);

    public native int hdr_usec();

    public native void hdr_usec(int var1);

    public native int hdr_wirelen();

    public native void hdr_wirelen(int var1);

    public long nanos() {
        return this.hdr_usec() * 1000;
    }

    public int peer(JBuffer jBuffer, int n) {
        return super.peer(jBuffer, n, PcapHeader.sizeof());
    }

    public int peerTo(JBuffer jBuffer, int n) {
        return super.peer(jBuffer, n, PcapHeader.sizeof());
    }

    public int peerTo(PcapHeader pcapHeader, int n) {
        return super.peer(pcapHeader, n, pcapHeader.size());
    }

    public long seconds() {
        return this.hdr_sec();
    }

    public long timestampInMillis() {
        long l = this.hdr_sec() * 1000L + (long)(this.hdr_usec() / 1000);
        return l;
    }

    public int transferTo(JBuffer jBuffer, int n) {
        return super.transferTo(jBuffer, 0, this.size(), n);
    }

    public int transferTo(byte[] byArray, int n) {
        return super.transferTo(byArray, 0, this.size(), n);
    }

    public int wirelen() {
        return this.hdr_wirelen();
    }

    public void caplen(int n) {
        throw new UnsupportedOperationException("Not allowed on PcapHeader");
    }

    public void nanos(long l) {
        throw new UnsupportedOperationException("Not allowed on PcapHeader");
    }

    public void seconds(long l) {
        throw new UnsupportedOperationException("Not allowed on PcapHeader");
    }

    public void wirelen(int n) {
        throw new UnsupportedOperationException("Not allowed on PcapHeader");
    }

    public void initFrom(JCaptureHeader jCaptureHeader) {
        throw new UnsupportedOperationException("Not allowed on PcapHeader");
    }

    public long timestampInNanos() {
        return this.hdr_sec() * 1000000000L + (long)(this.hdr_usec() * 1000);
    }

    public long timestampInMicros() {
        return this.hdr_sec() * 1000000L + (long)this.hdr_usec();
    }
}

